<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateBlocoRequest;
use App\Http\Requests\Admin\UpdateBlocoRequest;
use App\Repositories\Admin\BlocoRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class BlocoController extends AppBaseController
{
    /** @var  BlocoRepository */
    private $blocoRepository;

    public function __construct(BlocoRepository $blocoRepo)
    {
        $this->blocoRepository = $blocoRepo;
    }

    /**
     * Display a listing of the Bloco.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->blocoRepository->pushCriteria(new RequestCriteria($request));
        $blocos = $this->blocoRepository->all();

        return view('admin.blocos.index')
            ->with('blocos', $blocos);
    }

    /**
     * Show the form for creating a new Bloco.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.blocos.create');
    }

    /**
     * Store a newly created Bloco in storage.
     *
     * @param CreateBlocoRequest $request
     *
     * @return Response
     */
    public function store(CreateBlocoRequest $request)
    {
        $input = $request->all();

        $bloco = $this->blocoRepository->create_with_upload($input);

        Flash::success('Bloco salvo(a) com sucesso.');

        return redirect(route('admin.blocos.index'));
    }

    /**
     * Display the specified Bloco.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $bloco = $this->blocoRepository->findWithoutFail($id);

        if (empty($bloco)) {
            Flash::error('Bloco não encontrado(a)');

            return redirect(route('admin.blocos.index'));
        }

        return view('admin.blocos.show')->with('bloco', $bloco);
    }

    /**
     * Show the form for editing the specified Bloco.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $bloco = $this->blocoRepository->findWithoutFail($id);
        if (empty($bloco)) {
            Flash::error('Bloco não encontrado(a)');

            return redirect(route('admin.blocos.index'));
        }

        return view('admin.blocos.edit')->with('bloco', $bloco);
    }

    /**
     * Update the specified Bloco in storage.
     *
     * @param  int              $id
     * @param UpdateBlocoRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateBlocoRequest $request)
    {
        $bloco = $this->blocoRepository->findWithoutFail($id);

        if (empty($bloco)) {
            Flash::error('Bloco não encontrado(a)');

            return redirect(route('admin.blocos.index'));
        }

        $bloco = $this->blocoRepository->update_with_upload($request->all(), $id);

        Flash::success('Bloco editado(a) com sucesso.');

        return redirect(route('admin.blocos.index'));
    }

    /**
     * Remove the specified Bloco from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $bloco = $this->blocoRepository->findWithoutFail($id);

        if (empty($bloco)) {
            Flash::error('Bloco não encontrado(a)');

            return redirect(route('admin.blocos.index'));
        }

        $this->blocoRepository->destroy_with_upload($id);

        Flash::success('Bloco deletado(a) com sucesso.');

        return redirect(route('admin.blocos.index'));
    }


}
