<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateNoticiaRequest;
use App\Http\Requests\Admin\UpdateNoticiaRequest;
use App\Repositories\Admin\NoticiaRepository;
use App\Repositories\StatuRepository;

use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class NoticiaController extends AppBaseController
{
    /** @var  NoticiaRepository */
    private $noticiaRepository;

    public function __construct(NoticiaRepository $noticiaRepo, StatuRepository $statuRepository)
    {
        $this->noticiaRepository = $noticiaRepo;
        $this->statuRepository = $statuRepository;

    }

    /**
     * Display a listing of the Noticia.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->noticiaRepository->pushCriteria(new RequestCriteria($request));
        $noticias = $this->noticiaRepository->all();

        return view('admin.noticias.index')
            ->with('noticias', $noticias);
    }

    /**
     * Show the form for creating a new Noticia.
     *
     * @return Response
     */
    public function create()
    {
        $status = $this->statuRepository->statuSelectbox();

        return view('admin.noticias.create', compact('status'));
    }

    /**
     * Store a newly created Noticia in storage.
     *
     * @param CreateNoticiaRequest $request
     *
     * @return Response
     */
    public function store(CreateNoticiaRequest $request)
    {
        $input = $request->all();

        $noticia = $this->noticiaRepository->create_with_upload($input);

        Flash::success('Notícia salvo(a) com sucesso.');

        return redirect(route('admin.noticias.index'));
    }

    /**
     * Display the specified Noticia.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $noticia = $this->noticiaRepository->findWithoutFail($id);

        if (empty($bloco)) {
            Flash::error('Notícia não encontrado(a)');

            return redirect(route('admin.noticias.index'));
        }

        return view('admin.noticias.show')->with('noticia', $noticia);
    }

    /**
     * Show the form for editing the specified Notícia.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $noticia = $this->noticiaRepository->findWithoutFail($id);
        if (empty($noticia)) {
            Flash::error('Notícia não encontrado(a)');

            return redirect(route('admin.noticias.index'));
        }
        $status = $this->statuRepository->statuSelectbox();

        return view('admin.noticias.edit')->with('noticia', $noticia)->with('status', $status);
    }

    /**
     * Update the specified Notícia in storage.
     *
     * @param  int              $id
     * @param UpdateNoticiaRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateNoticiaRequest $request)
    {
        $noticia = $this->noticiaRepository->findWithoutFail($id);

        if (empty($noticia)) {
            Flash::error('Notícia não encontrado(a)');

            return redirect(route('admin.noticias.index'));
        }

        $noticia = $this->noticiaRepository->update_with_upload($request->all(), $id);

        Flash::success('Notícia editado(a) com sucesso.');

        return redirect(route('admin.noticias.index'));
    }

    /**
     * Remove the specified Bloco from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $noticia = $this->noticiaRepository->findWithoutFail($id);

        if (empty($noticia)) {
            Flash::error('Notícia não encontrado(a)');

            return redirect(route('admin.noticias.index'));
        }

        $this->noticiaRepository->destroy_with_upload($id);

        Flash::success('Notícia deletado(a) com sucesso.');

        return redirect(route('admin.noticias.index'));
    }

    public function ativar($id)
        {
            $id = base64_decode($id);
            $this->noticiaRepository->ativar($id);
            Flash::success('Notícia ativado(a) com sucesso.');
            return redirect(route('admin.noticias.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->noticiaRepository->inativar($id);
            Flash::success('Notícia inativado(a) com sucesso.');
            return redirect(route('admin.noticias.index'));
        }


}
