<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreatePerguntaRequest;
use App\Http\Requests\Admin\UpdatePerguntaRequest;
use App\Repositories\Admin\FaqRepository;
use App\Repositories\Admin\PerguntaRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class PerguntaController extends AppBaseController
{
    /** @var  PerguntaRepository */
    private $perguntaRepository;

    public function __construct(PerguntaRepository $perguntaRepo, FaqRepository $faqRepository)
    {
        $this->perguntaRepository = $perguntaRepo;
        $this->faqRepository = $faqRepository;
    }

    /**
     * Display a listing of the Pergunta.
     *
     * @param Request $request
     * @return Response
     */
    public function index($faq_id, Request $request)
    {
        $this->perguntaRepository->pushCriteria(new RequestCriteria($request));
        $perguntas = $this->perguntaRepository->all();
        $faq = $this->faqRepository->find($faq_id, ['nome', 'id']);

        return view('admin.perguntas.index')
            ->with('perguntas', $perguntas)
            ->with('faq', $faq);
    }

    /**
     * Show the form for creating a new Pergunta.
     *
     * @return Response
     */
    public function create($faq_id)
    {
        $faq = $this->faqRepository->find($faq_id, ['nome', 'id']);
        return view('admin.perguntas.create', compact('faq_id'))->with('faq', $faq);
    }

    /**
     * Store a newly created Pergunta in storage.
     *
     * @param CreatePerguntaRequest $request
     *
     * @return Response
     */
    public function store(CreatePerguntaRequest $request)
    {
        $input = $request->all();

        $pergunta = $this->perguntaRepository->create($input);

        Flash::success('Pergunta salvo(a) com sucesso.');

       // return redirect(route('admin.perguntas.index'));

        return redirect('/admin/perguntas/'.$pergunta->faq_id);
    }

    public function edit($faq_id,$id)
    {
        $pergunta = $this->perguntaRepository->findWithoutFail($id);

        if (empty($pergunta)) {
            Flash::error('Pergunta não encontrado(a)');

            return redirect(route('admin.perguntas.index'));
        }
        $faq = $this->faqRepository->find($faq_id, ['nome', 'id']);
        return view('admin.perguntas.edit')->with('pergunta', $pergunta)->with('faq', $faq);
    }

    /**
     * Update the specified Pergunta in storage.
     *
     * @param  int              $id
     * @param UpdatePerguntaRequest $request
     *
     * @return Response
     */
    public function update($id, UpdatePerguntaRequest $request)
    {
        $pergunta = $this->perguntaRepository->findWithoutFail($id);

        if (empty($pergunta)) {
            Flash::error('Pergunta não encontrado(a)');

            return redirect(route('admin.perguntas.index'));
        }

        $pergunta = $this->perguntaRepository->update($request->all(), $id);

        Flash::success('Pergunta editado(a) com sucesso.');

       // return redirect(route('admin.perguntas.index'));
        return redirect('/admin/perguntas/'.$pergunta->faq_id);
    }

    /**
     * Remove the specified Pergunta from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $pergunta = $this->perguntaRepository->findWithoutFail($id);

        if (empty($pergunta)) {
            Flash::error('Pergunta não encontrado(a)');

            return redirect(route('admin.perguntas.index'));
        }

        $this->perguntaRepository->delete($id);

        Flash::success('Pergunta deletado(a) com sucesso.');

       // return redirect(route('admin.perguntas.index'));
        return redirect('/admin/perguntas/'.$pergunta->faq_id);
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->perguntaRepository->ativar($id);
            Flash::success('Pergunta ativado(a) com sucesso.');
            return redirect(route('admin.perguntas.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->perguntaRepository->inativar($id);
            Flash::success('Pergunta inativado(a) com sucesso.');
            return redirect(route('admin.perguntas.index'));
        }

}
