<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateServicoRequest;
use App\Http\Requests\Admin\UpdateServicoRequest;
use App\Repositories\Admin\ServicoRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;
use Illuminate\Support\Str;

class ServicoController extends AppBaseController
{
    /** @var  ServicoRepository */
    private $servicoRepository;

    public function __construct(ServicoRepository $servicoRepo)
    {
        $this->servicoRepository = $servicoRepo;
    }

    /**
     * Display a listing of the Servico.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->servicoRepository->pushCriteria(new RequestCriteria($request));
        $servicos = $this->servicoRepository->all();

        return view('admin.servicos.index')
            ->with('servicos', $servicos);
    }

    /**
     * Show the form for creating a new Servico.
     *
     * @return Response
     */
    public function create()
    {
        return view('admin.servicos.create');
    }

    /**
     * Store a newly created Servico in storage.
     *
     * @param CreateServicoRequest $request
     *
     * @return Response
     */
    public function store(CreateServicoRequest $request)
    {
        $input = $request->all();

        $input['slug'] = Str::slug($input['nome'], '-');
        dd($input);
        $verifica = $this->servicoRepository->verificaSlug($input['slug']);

        $erro = '';
        if(!$verifica) {
            $servico = $this->servicoRepository->create_with_upload($input);
            Flash::success('Serviço salvo(a) com sucesso.');
        }else{
            $erro = 'Já existe um serviço com esse nome.';
            Flash::error($erro);
        }

        return redirect(route('admin.servicos.index'));
    }

    /**
     * Display the specified Servico.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $servico = $this->servicoRepository->findWithoutFail($id);

        if (empty($servico)) {
            Flash::error('Serviço não encontrado(a)');

            return redirect(route('admin.servicos.index'));
        }

        return view('admin.servicos.show')->with('servico', $servico);
    }

    /**
     * Show the form for editing the specified Servico.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $servico = $this->servicoRepository->findWithoutFail($id);

        if (empty($servico)) {
            Flash::error('Serviço não encontrado(a)');

            return redirect(route('admin.servicos.index'));
        }

        return view('admin.servicos.edit')->with('servico', $servico);
    }

    /**
     * Update the specified Servico in storage.
     *
     * @param  int              $id
     * @param UpdateServicoRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateServicoRequest $request)
    {
        $servico = $this->servicoRepository->findWithoutFail($id);

        if (empty($servico)) {
            Flash::error('Serviço não encontrado(a)');

            return redirect(route('admin.servicos.index'));
        }

        $input = $request->all();
        $input['slug'] = Str::slug($input['nome'], '-');

        $servico = $this->servicoRepository->update_with_upload($input, $id);

        Flash::success('Serviço editado(a) com sucesso.');

        return redirect(route('admin.servicos.index'));
    }

    /**
     * Remove the specified Servico from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $servico = $this->servicoRepository->findWithoutFail($id);

        if (empty($servico)) {
            Flash::error('Servico não encontrado(a)');

            return redirect(route('admin.servicos.index'));
        }

        $this->servicoRepository->delete($id);

        Flash::success('Serviço deletado(a) com sucesso.');

        return redirect(route('admin.servicos.index'));
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->servicoRepository->ativar($id);
            Flash::success('Servico ativado(a) com sucesso.');
            return redirect(route('admin.servicos.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->servicoRepository->inativar($id);
            Flash::success('Servico inativado(a) com sucesso.');
            return redirect(route('admin.servicos.index'));
        }

}
