<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateServicosfotoRequest;
use App\Http\Requests\Admin\UpdateServicosfotoRequest;
use App\Repositories\Admin\ServicoRepository;
use App\Repositories\Admin\ServicosfotoRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;

class ServicosfotoController extends AppBaseController
{
    /** @var  ServicosfotoRepository */
    private $servicosfotoRepository;

    public function __construct(ServicosfotoRepository $servicosfotoRepo, ServicoRepository $servicoRepository)
    {
        $this->servicosfotoRepository = $servicosfotoRepo;
        $this->servicoRepository = $servicoRepository;
    }

    /**
     * Display a listing of the Servicosfoto.
     *
     * @param Request $request
     * @return Response
     */
    public function index($servico_id, Request $request)
    {
        $this->servicosfotoRepository->pushCriteria(new RequestCriteria($request));
        $servicosfotos = $this->servicosfotoRepository->findWhere(['servico_id' => $servico_id]);
        $servico = $this->servicoRepository->find($servico_id, ['nome', 'id']);

        return view('admin.servicosfotos.index')
            ->with('servicosfotos', $servicosfotos)
            ->with('servico', $servico);
    }

    /**
     * Show the form for creating a new Servicosfoto.
     *
     * @return Response
     */
    public function create($servico_id)
    {
        return view('admin.servicosfotos.create', compact('servico_id'));
    }

    /**
     * Store a newly created Servicosfoto in storage.
     *
     * @param CreateServicosfotoRequest $request
     *
     * @return Response
     */
    public function store(CreateServicosfotoRequest $request)
    {
        ini_set('memory_limit', '-1');
        $input = $request->all();

        if (isset($input['qqfilename'])){
            $input['titulo'] = $input['qqfilename'];
            $input['foto'] = $input['qqfile'];
        }

        $servicosfoto = $this->servicosfotoRepository->create_with_upload($input);

        if(isset($input['qqfilename'])){
            if($servicosfoto){
                die('{"success":true}');
            } else {
                die('{"error": "Erro ao tentar cadastrar esta foto, tente novamente!"}');
            }
        }


        Flash::success('Fotos do serviço salvo(a)s com sucesso.');

        return redirect(route('admin.servicosfotos.index'));
    }

    /**
     * Display the specified Servicosfoto.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function show($id)
    {
        $servicosfoto = $this->servicosfotoRepository->findWithoutFail($id);

        if (empty($servicosfoto)) {
            Flash::error('Servicosfoto não encontrado(a)');

            return redirect(route('admin.servicosfotos.index'));
        }

        return view('admin.servicosfotos.show')->with('servicosfoto', $servicosfoto);
    }

    /**
     * Show the form for editing the specified Servicosfoto.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($servico_id, $id)
    {
        $servicosfoto = $this->servicosfotoRepository->findWithoutFail($id);
        $servico = $this->servicoRepository->find($servico_id, ['nome', 'id']);
        if (empty($servicosfoto)) {
            Flash::error('Servicosfoto não encontrado(a)');

            return redirect(route('admin.servicosfotos.index'));
        }

        return view('admin.servicosfotos.edit')->with('servicosfoto', $servicosfoto)->with('servico', $servico);
    }

    /**
     * Update the specified Servicosfoto in storage.
     *
     * @param  int              $id
     * @param UpdateServicosfotoRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateServicosfotoRequest $request)
    {
        $servicosfoto = $this->servicosfotoRepository->findWithoutFail($id);

        if (empty($servicosfoto)) {
            Flash::error('Foto não encontrado(a)');

            return redirect(route('admin.servicosfotos.index'));
        }

        $servicosfoto = $this->servicosfotoRepository->update($request->all(), $id);

        Flash::success('Foto editado(a) com sucesso.');

        return redirect('/admin/servicosfotos/'.$servicosfoto->servico_id);

       // return redirect()->route('admin.servicosfotos.index', [$servicosfoto->servico_id]);


    }

    /**
     * Remove the specified Servicosfoto from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        $servicosfoto = $this->servicosfotoRepository->findWithoutFail($id);

        if (empty($servicosfoto)) {
            Flash::error('Servicosfoto não encontrado(a)');

            return redirect(route('admin.servicosfotos.index'));
        }

        $this->servicosfotoRepository->delete($id);

        Flash::success('Servicosfoto deletado(a) com sucesso.');

        //return redirect(route('admin.servicosfotos.index'));
        return redirect('/admin/servicosfotos/'.$servicosfoto->servico_id);
    }

      public function ativar($id)
        {
            $id = base64_decode($id);
            $this->servicosfotoRepository->ativar($id);
            Flash::success('Servicosfoto ativado(a) com sucesso.');
            return redirect(route('admin.servicosfotos.index'));
        }

        public function inativar($id)
        {
            $id = base64_decode($id);
            $this->servicosfotoRepository->inativar($id);
            Flash::success('Servicosfoto inativado(a) com sucesso.');
            return redirect(route('admin.servicosfotos.index'));
        }

}
