<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\CreateUserRequest;
use App\Http\Requests\Admin\UpdateUserRequest;
use App\Repositories\Admin\UserRepository;
use App\Http\Controllers\AppBaseController;
use Illuminate\Http\Request;
use Flash;
use Prettus\Repository\Criteria\RequestCriteria;
use Response;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Auth\Guard;

class UserController extends AppBaseController
{
    /** @var  UserRepository */
    private $userRepository;
    protected $auth;

    public function __construct(UserRepository $userRepo, Guard $auth)
    {
        $this->userRepository = $userRepo;
        $this->auth = $auth;
    }

    /**
     * Display a listing of the User.
     *
     * @param Request $request
     * @return Response
     */
    public function index(Request $request)
    {
        $this->userRepository->pushCriteria(new RequestCriteria($request));
        $users = $this->userRepository->findByField('role_id',1);
        return view('admin.users.index')->with('users', $users);
    }

    /**
     * Show the form for creating a new User.
     *
     * @return Response
     */
    public function create()
    {
        if ($this->auth->user()->id == 1)
            return view('admin.users.create');
        else
            return redirect(route('admin.users.index'));
    }

    /**
     * Store a newly created User in storage.
     *
     * @param CreateUserRequest $request
     *
     * @return Response
     */
    public function store(CreateUserRequest $request)
    {
        if ($this->auth->user()->id == 1) {
            $input = $request->all();

            $input['password'] = Hash::make($input['password']);
            $input['role_id'] = 1;
            $input['statu_id'] = 1;

            $user = $this->userRepository->create($input);

            Flash::success('Usuário salvo com sucesso.');

            return redirect(route('admin.users.index'));
        }
        else {
            return redirect(route('admin.users.index'));
        }
    }


    /**
     * Show the form for editing the specified User.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        if ($this->auth->user()->id == 1 || $this->auth->user()->id == $id) {
            $user = $this->userRepository->findWithoutFail($id);
            if (empty($user)) {
                Flash::error('Usuário não encontrado');

                return redirect(route('admin.users.index'));
            }
            return view('admin.users.edit')->with('user', $user);
        }else {
            return redirect(route('admin.users.index'));
        }
    }

    /**
     * Update the specified User in storage.
     *
     * @param  int              $id
     * @param UpdateUserRequest $request
     *
     * @return Response
     */
    public function update($id, UpdateUserRequest $request)
    {
        if ($this->auth->user()->id == 1 || $this->auth->user()->id == $id) {
            $user = $this->userRepository->findWithoutFail($id);

            if (empty($user)) {
                Flash::error('Usuário não encontrado');

                return redirect(route('admin.users.index'));
            }

            $input = $request->all();
            $input['password'] = Hash::make($input['password']);

            $user = $this->userRepository->update($input, $id);

            Flash::success('Usuário editado com sucesso.');

            return redirect(route('admin.users.index'));
        }else {
            return redirect(route('admin.users.index'));
        }
    }

    /**
     * Remove the specified User from storage.
     *
     * @param  int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        if ($this->auth->user()->id == 1) {
            $user = $this->userRepository->findWithoutFail($id);

            if (empty($user)) {
                Flash::error('Usuário não encontrado');
                return redirect(route('admin.users.index'));
            }

            $this->userRepository->delete($id);

            Flash::success('Usuário deletado com sucesso.');

            return redirect(route('admin.users.index'));
        }else {
            return redirect(route('admin.users.index'));
        }
    }

    public function ativar($id)
    {
        if ($this->auth->user()->id == 1) {
        $id = base64_decode($id);
        $this->userRepository->ativar($id);
        Flash::success('Usuário ativado com sucesso.');
        return redirect(route('admin.users.index'));
        }else {
            return redirect(route('admin.users.index'));
        }
    }

    public function inativar($id)
    {
        if ($this->auth->user()->id == 1) {
        $id = base64_decode($id);
        $this->userRepository->inativar($id);
        Flash::success('Usuário inativado com sucesso.');
        return redirect(route('admin.users.index'));
        }else {
            return redirect(route('admin.users.index'));
        }
    }

}
