<?php

namespace App\Http\Controllers;


use App\Repositories\NoticiaRepository;
use App\Repositories\Admin\BlocoRepository;
use Illuminate\Contracts\Auth\Guard;
use Illuminate\Support\Facades\Request;
use App\Services\MailService;
use Illuminate\Support\Facades\Session;


class NoticiaController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(NoticiaRepository $noticiaRepository,  BlocoRepository $blocoRepository)
    {
        $this->noticiaRepository = $noticiaRepository;
        $this->blocoRepository = $blocoRepository;

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function ver()
    {
        $noticias =  $this->noticiaRepository->all();

        $blocos = $this->blocoRepository->orderBy('ordem', 'asc')->all();

        if (isset($noticias)) {

            return view('noticias.ver',compact('noticias','blocos'));
        } else {
            return redirect(route('home'));
        }

    }

}
