<?php

namespace App\Http\Controllers;

use App\Repositories\VeiculoRepository;
use App\Repositories\Admin\DestaqueRepository;

use Illuminate\Contracts\Auth\Guard;
use Illuminate\Support\Facades\Request;
use App\Services\MailService;
use Illuminate\Support\Facades\Session;


class VeiculoController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(VeiculoRepository $veiculoRepository, DestaqueRepository $destaqueRepository)
    {
        $this->veiculoRepository = $veiculoRepository;
        $this->destaqueRepository = $destaqueRepository;

    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function ver($id)
    {

        $veiculo =  $this->veiculoRepository->ver($id);
        $fotos =  $this->veiculoRepository->fotos($id);
        $destaques = $this->destaqueRepository->findWhere(['destaque' => 1]);

        if (isset($veiculo)) {

            return view('veiculos.ver',compact('veiculo','fotos','destaques'));
        } else {
            return redirect(route('home'));
        }

    }

}
