<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Configuracoe
 * @package App\Models\Admin
 * @version June 28, 2018, 8:13 pm UTC
 *
 * @property string nome_aplicacao
 * @property string email
 * @property string meta_keyword
 * @property string meta_description
 * @property string facebook
 * @property string instagram
 * @property string twitter
 * @property string linkedin
 */
class Configuracoe extends Model
{

    public $table = 'configuracoes';

    public $timestamps = false;

    public $fillable = [
        'nome_aplicacao',
        'email',
        'emailrh',
        'meta_keyword',
        'meta_description',
        'facebook',
        'instagram',
        'linkedin',
        'youtube',
        'funcionamento',
        'logorodape',
        'login',
        'rua',
        'bairro',
        'numero',
        'cidade',
        'estado',
        'cep',
        'responsaveis',
        'razaosocial',
        'apiwhatsapp',
        'exames',
        'contatos',
        'manutencao',
        'mapa',
        'loja'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'nome_aplicacao' => 'string',
        'email' => 'string',
        'emailrh' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'facebook' => 'string',
        'instagram' => 'string',
        'linkedin' => 'string',
        'youtube' => 'string',
        'funcionamento' => 'string',
        'logorodape' => 'string',
        'login' => 'string',
        'rua' => 'string',
        'bairro' => 'string',
        'numero' => 'integer',
        'cidade' => 'string',
        'estado' => 'string',
        'cep' => 'string',
        'responsaveis' => 'string',
        'razaosocial' => 'string',
        'apiwhatsapp' => 'string',
        'exames' => 'string',
        'contatos' => 'string',
        'manutencao' => 'integer',
        'mapa' => 'string',
        'loja' => 'string'

    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'logo' => 'image|mimes:jpeg,png,jpg,webp|max:5242880',
        'logorodape' => 'image|mimes:jpeg,png,jpg,webp|max:5242880',
        'login' => 'image|mimes:jpeg,png,jpg,webp|max:5242880'

    ];


}
