<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Destaquefoto
 * @package App\Models\Admin
 * @version September 3, 2019, 2:41 pm -03
 *
 * @property string titulo
 * @property string foto
 * @property integer ordem
 * @property integer destaque_id
 */
class Destaquefoto extends Model
{

    public $table = 'destaquefotos';


    public $fillable = [
        'titulo',
        'foto',
        'ordem',
        'destaque_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'titulo' => 'string',
        'foto' => 'string',
        'ordem' => 'integer',
        'destaque_id' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'foto' => 'image|mimes:jpeg,png,jpg,webp|max:5242880'
    ];

    public function destaques(){
        return $this->belongsTo('App\Destaque', 'destaque_id');
    }
}
