<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Faq
 * @package App\Models\Admin
 * @version September 3, 2019, 7:14 pm -03
 *
 * @property string nome
 * @property integer pagina_id
 */
class Faq extends Model
{

    public $table = 'faqs';
    


    public $fillable = [
        'nome',
        'pagina_id'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'nome' => 'string',
        'pagina_id' => 'integer'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        
    ];
    public function paginas(){
        return $this->belongsTo('App\Models\Admin\Pagina', 'pagina_id');
    }
    public function perguntas(){
        return $this->hasMany('App\Models\Admin\Pergunta', 'faq_id');
    }
}
