<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Home
 * @package App\Models
 * @version September 23, 2019, 11:47 am -03
 *
 * @property string text_sobre
 * @property string link_sobre
 * @property string bg
 * @property string titulo_home
 * @property string subtitulo_home
 * @property string subtitulo_suasaude
 * @property string subtitulo_convenio
 * @property string subtitulo_faleconosco
 * @property string subtitulo_trabalhe
 * @property string subtitulo_demonstrativos
 */
class Home extends Model
{

    public $table = 'homes';
    public $timestamps = false;



    public $fillable = [
        'text_sobre',
        'link_sobre',
        'bg',
        'titulo_home',
        'subtitulo_home',
        'subtitulo_suasaude',
        'subtitulo_convenio',
        'subtitulo_faleconosco',
        'subtitulo_trabalhe',
        'subtitulo_demonstrativos'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'text_sobre' => 'string',
        'link_sobre' => 'string',
        'bg' => 'string',
        'titulo_home' => 'string',
        'subtitulo_home' => 'string',
        'subtitulo_suasaude' => 'string',
        'subtitulo_convenio' => 'string',
        'subtitulo_faleconosco' => 'string',
        'subtitulo_trabalhe' => 'string',
        'subtitulo_demonstrativos' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'bg' => 'image|mimes:jpeg,png,jpg,webp|max:5242880'
    ];


}
