<?php

namespace App\Models\Admin;

use Eloquent as Model;

/**
 * Class Servico
 * @package App\Models\Admin
 * @version September 3, 2019, 2:53 pm -03
 *
 * @property string nome
 * @property string subtitulo
 * @property string descricao
 * @property string foto
 * @property integer onmenu
 */
class Servico extends Model
{

    public $table = 'servicos';



    public $fillable = [
        'nome',
        'subtitulo',
        'descricao',
        'foto',
        'onmenu',
        'slug'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'nome' => 'string',
        'subtitulo' => 'string',
        'descricao' => 'string',
        'foto' => 'string',
        'onmenu' => 'integer',
        'slug' => 'string'
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [
        'foto' => 'image|mimes:jpeg,png,jpg,webp|max:5242880'
    ];

    public function servicosfotos(){
        return $this->hasMany('App\Models\Admin\Servicosfoto', 'servico_id');
    }

}
