<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Notifications\ResetPassword as ResetPasswordNotification;

/**
 * Class User
 * @package App\Models\Admin
 * @version July 18, 2018, 5:17 pm UTC
 *
 * @property \Illuminate\Database\Eloquent\Collection clientes
 * @property \Illuminate\Database\Eloquent\Collection cursos
 * @property \Illuminate\Database\Eloquent\Collection videos
 * @property string nome
 * @property string email
 * @property string password
 * @property string username
 * @property integer role_id
 * @property integer statu_id
 * @property integer cliente_id
 * @property string remember_token
 */
class User extends Authenticatable
{

    use Notifiable;

    public $table = 'users';

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';



    public $fillable = [
        'nome',
        'email',
        'password',
        'username',
        'role_id',
        'statu_id',
        'cliente_id',
        'remember_token'
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'id' => 'integer',
        'nome' => 'string',
        'email' => 'string',
        'password' => 'string',
        'username' => 'string',
        'role_id' => 'integer',
        'statu_id' => 'integer',
        'cliente_id' => 'integer',
        'remember_token' => 'string'
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [

    ];

    public function roles(){
        return $this->belongsTo('App\Role', 'role_id');
    }
    public function status(){
        return $this->belongsTo('Statu');
    }

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($token));
    }



}
