<?php

namespace App\Providers;

use App\Models\Admin\Servico;
use Illuminate\Support\ServiceProvider;
use App\Models\Admin\Configuracoe;
use App\Models\Admin\Integracao;
use App\Models\Admin\Pagina;
use App\Models\Admin\Telefone;
use Illuminate\Support\Facades\View;
use Illuminate\Http\Request;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $config = Configuracoe::findOrFail(1);

        $integracoes = Integracao::findOrFail(1);
        $title_for_layout = 'LBus Brasil';

        $paginas_menu = Pagina::where(['statu_id' => 1, 'onmenu' => 1, 'pagina_id' => null])->orderBy('ordem', 'asc')->with('paginas')->get();
        $paginas_rodape = Pagina::where(['statu_id' => 1, 'onfooter' => 1])->orderBy('ordem', 'asc')->get();
        $telefone_principal = Telefone::where('tipo', 'Telefone Principal')->pluck('numero','link');
        $telefone = Telefone::where('tipo', 'Telefone')->pluck('numero','link');
        $whatsapp = Telefone::where('tipo', 'Whatsapp')->pluck('numero','link');
        $servicos = Servico::where('onmenu', 1)->orderBy('nome', 'asc')->get();

        View::share('configuracoes', $config);
        View::share('integracoes', $integracoes);

        View::share('telefone', $telefone);
        View::share('telefone_principal', $telefone_principal);

        View::share('whatsapp', $whatsapp);
        View::share('paginas_menu', $paginas_menu);
        View::share('paginas_rodape', $paginas_rodape);
        View::share('title_for_layout', $title_for_layout);
        View::share('servicos', $servicos);

    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }


}
