<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Bannersinterno;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class BannersinternoRepository
 * @package App\Repositories\Admin
 * @version August 26, 2019, 8:05 pm -03
 *
 * @method Bannersinterno findWithoutFail($id, $columns = ['*'])
 * @method Bannersinterno find($id, $columns = ['*'])
 * @method Bannersinterno first($columns = ['*'])
 */
class BannersinternoRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'acessarblog',
        'trabalheconosco'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Bannersinterno::class;
    }

    function create_with_upload ($attributes) {

        $file = $attributes['acessarblog'];
        list($width, $height) = getimagesize($file);

        $attributes['acessarblog'] =  $this->imgUpload($file,'bannersinternos', $width, $height);

        $file = $attributes['trabalheconosco'];
        list($width, $height) = getimagesize($file);

        $attributes['trabalheconosco'] =  $this->imgUpload($file,'bannersinternos',$width, $height);

        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::create($attributes);
        $this->skipPresenter($temporarySkipPresenter);
        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);

    }

    public function update_with_upload(array $attributes, $id)
    {

        $bannersinterno = $this->findWithoutFail($id);
        $acessarblog = isset ($attributes['acessarblog']) ? $attributes['acessarblog'] : '';
        $trabalheconosco = isset ($attributes['trabalheconosco']) ? $attributes['trabalheconosco'] : '';

        if(!empty($acessarblog)){
            \File::delete('uploads/bannersinternos/'.$bannersinterno->acessarblog);
            list($width, $height) = getimagesize($acessarblog);

            $attributes['acessarblog'] =  $this->imgUpload($acessarblog,'bannersinternos', $width, $height);
        }
        if(!empty($trabalheconosco)){
            \File::delete('uploads/bannersinternos/'.$bannersinterno->trabalheconosco);
            list($width, $height) = getimagesize($trabalheconosco);

            $attributes['trabalheconosco'] =  $this->imgUpload($trabalheconosco,'bannersinternos',$width, $height);
        }

        // Have to skip presenter to get a model not some data
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::update($attributes, $id);
        $this->skipPresenter($temporarySkipPresenter);

        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);
    }

    function destroy_with_upload ($id, $bannersinterno) {
        $imagem = $bannersinterno->foto;
        if ($bannersinterno->destroy($id)) {
            \File::delete(public_path('uploads/bannersinternos/'.$imagem));
            \File::delete(public_path('uploads/bannersinternos/sm'.$imagem));
        }
    }


    public function ativar($id)
    {
        $bannersinterno = Bannersinterno::findOrFail($id);
        $bannersinterno->statu_id = 1;
        if ($bannersinterno->save()) {
            return true;
        }
        return false;
    }

    public function inativar($id)
    {
        $bannersinterno = Bannersinterno::findOrFail($id);
        $bannersinterno->statu_id = 2;
        if ($bannersinterno->save()) {
            return true;
        }
        return false;
    }

    public function imgUpload($file, $path, $width, $height){


        $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
        $path = 'uploads/'.$path.'/';
        if (!file_exists($path)) {
            File::makeDirectory($path, 0777, true, true);
        }
        Image::make($file)->resize($width, $height)->save($path.$file_name);
        Image::make($file)->resize($width/6, $height/6)->save($path.'sm'.$file_name);

        return $file_name;
    }
}
