<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Destaque;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class DestaqueRepository
 * @package App\Repositories\Admin
 * @version August 26, 2019, 7:12 pm -03
 *
 * @method Destaque findWithoutFail($id, $columns = ['*'])
 * @method Destaque find($id, $columns = ['*'])
 * @method Destaque first($columns = ['*'])
*/
class DestaqueRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'titulo',
        'foto',
        'tipo_id',
        'informacoes',
        'statu_id',
        'destaque',
        'youtube',
        'valor',
        'marca',
        'modelo',
        'carroceria',
        'chassi',
        'ano',
        'direcao',
        'lugares',
        'ar',
        'portas',
        'combustivel'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Destaque::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['foto'];
            $attributes['foto'] =  $this->imgUpload($file,'destaques');
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $destaque = $this->findWithoutFail($id);
            $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/destaques/'.$destaque->foto));
                \File::delete(public_path('uploads/destaques/sm'.$destaque->foto));

                $attributes['foto'] =  $this->imgUpload($file,'destaques');
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id, $destaque) {
            $imagem = $destaque->foto;
            if ($destaque->destroy($id)) {
                \File::delete(public_path('uploads/destaques/'.$imagem));
                \File::delete(public_path('uploads/destaques/sm'.$imagem));
            }
        }


        public function ativar($id)
        {
            $destaque = Destaque::findOrFail($id);
            $destaque->statu_id = 1;
            if ($destaque->save()) {
                return true;
            }
            return false;
        }

        public function inativar($id)
        {
           $destaque = Destaque::findOrFail($id);
           $destaque->statu_id = 2;
            if ($destaque->save()) {
                return true;
            }
            return false;
        }

        public function imgUpload($file, $path){

            $width= 380;
            $height=188;

            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';                  if (!file_exists($path)) {             File::makeDirectory($path, 0777, true, true);         }
            Image::make($file)->resize($width, $height)->save($path.$file_name);
            Image::make($file)->resize($width/6, $height/6)->save($path.'sm'.$file_name);

            return $file_name;
        }
}
