<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Faq;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class FaqRepository
 * @package App\Repositories\Admin
 * @version September 3, 2019, 7:14 pm -03
 *
 * @method Faq findWithoutFail($id, $columns = ['*'])
 * @method Faq find($id, $columns = ['*'])
 * @method Faq first($columns = ['*'])
*/
class FaqRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'nome',
        'pagina_id'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Faq::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['foto'];
            $attributes['foto'] =  $this->imgUpload($file,'faqs');
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $faq = $this->findWithoutFail($id);
            $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/faqs/'.$faq->foto));
                \File::delete(public_path('uploads/faqs/sm'.$faq->foto));

                $attributes['foto'] =  $this->imgUpload($file,'faqs');
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id, $faq) {
            $imagem = $faq->foto;
            if ($faq->destroy($id)) {
                \File::delete(public_path('uploads/faqs/'.$imagem));
                \File::delete(public_path('uploads/faqs/sm'.$imagem));
            }
        }


        public function ativar($id)
        {
            $faq = Faq::findOrFail($id);
            $faq->statu_id = 1;
            if ($faq->save()) {
                return true;
            }
            return false;
        }

        public function inativar($id)
        {
           $faq = Faq::findOrFail($id);
           $faq->statu_id = 2;
            if ($faq->save()) {
                return true;
            }
            return false;
        }

        public function imgUpload($file, $path){
            $width= 1300;
            $height=560;

            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';                  if (!file_exists($path)) {             File::makeDirectory($path, 0777, true, true);         }
            Image::make($file)->resize($width, $height)->save($path.$file_name);
            Image::make($file)->resize($width/6, $height/6)->save($path.'sm'.$file_name);

            return $file_name;
        }
}
