<?php

namespace App\Repositories\Admin;

use App\Models\Admin\Home;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class HomeRepository
 * @package App\Repositories
 * @version September 23, 2019, 11:47 am -03
 *
 * @method Home findWithoutFail($id, $columns = ['*'])
 * @method Home find($id, $columns = ['*'])
 * @method Home first($columns = ['*'])
*/
class HomeRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'text_sobre',
        'link_sobre',
        'bg',
        'titulo_home',
        'subtitulo_home',
        'subtitulo_suasaude',
        'subtitulo_convenio',
        'subtitulo_faleconosco',
        'subtitulo_trabalhe',
        'subtitulo_demonstrativos'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Home::class;
    }

      function create_with_upload ($attributes) {

            $file = $attributes['bg'];
            $attributes['bg'] =  $this->imgUpload($file,'homes');
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::create($attributes);
            $this->skipPresenter($temporarySkipPresenter);
            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);

        }

        public function update_with_upload(array $attributes, $id)
        {

            $home = $this->findWithoutFail($id);
            $file = isset ($attributes['bg']) ? $attributes['bg'] : '';
            if(!empty($file)){
                \File::delete(public_path('uploads/homes/'.$home->bg));

                $attributes['bg'] =  $this->imgUpload($file,'homes');
            }

            // Have to skip presenter to get a model not some data
            $temporarySkipPresenter = $this->skipPresenter;
            $this->skipPresenter(true);
            $model = parent::update($attributes, $id);
            $this->skipPresenter($temporarySkipPresenter);

            $model = $this->updateRelations($model, $attributes);
            $model->save();

            return $this->parserResult($model);
        }

        function destroy_with_upload ($id, $home) {
            $imagem = $home->bg;
            if ($home->destroy($id)) {
                \File::delete(public_path('uploads/homes/'.$imagem));
            }
        }


        public function ativar($id)
        {
            $home = Home::findOrFail($id);
            $home->statu_id = 1;
            if ($home->save()) {
                return true;
            }
            return false;
        }

        public function inativar($id)
        {
           $home = Home::findOrFail($id);
           $home->statu_id = 2;
            if ($home->save()) {
                return true;
            }
            return false;
        }

        public function imgUpload($file, $path){
            $width= 1300;
            $height=500;

            $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
            $path = 'uploads/'.$path.'/';                  if (!file_exists($path)) {             File::makeDirectory($path, 0777, true, true);         }
            Image::make($file)->resize($width, $height)->save($path.$file_name);


            return $file_name;
        }
}
