<?php

namespace App\Repositories\Admin;

use App\Models\User;
use InfyOm\Generator\Common\BaseRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\ImageManagerStatic as Image;

/**
 * Class UserRepository
 * @package App\Repositories\Admin
 * @version July 18, 2018, 5:17 pm UTC
 *
 * @method User findWithoutFail($id, $columns = ['*'])
 * @method User find($id, $columns = ['*'])
 * @method User first($columns = ['*'])
 */
class UserRepository extends BaseRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'nome',
        'email',
        'password',
        'username',
        'role_id',
        'statu_id',
        'cliente_id',
        'remember_token'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return User::class;
    }

    function create_with_upload ($attributes) {

        $file = $attributes['foto'];
        $attributes['foto'] =  $this->imgUpload($file,'users');
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::create($attributes);
        $this->skipPresenter($temporarySkipPresenter);
        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);

    }

    public function update_with_upload(array $attributes, $id)
    {

        $user = $this->findWithoutFail($id);
        $file = isset ($attributes['foto']) ? $attributes['foto'] : '';
        if(!empty($file)){
            \File::delete(public_path('uploads/users/'.$user->foto));
            \File::delete(public_path('uploads/users/sm'.$user->foto));

            $attributes['foto'] =  $this->imgUpload($file,'users');
        }

        // Have to skip presenter to get a model not some data
        $temporarySkipPresenter = $this->skipPresenter;
        $this->skipPresenter(true);
        $model = parent::update($attributes, $id);
        $this->skipPresenter($temporarySkipPresenter);

        $model = $this->updateRelations($model, $attributes);
        $model->save();

        return $this->parserResult($model);
    }

    function destroy_with_upload ($id, $user) {
        $imagem = $user->foto;
        if ($user->destroy($id)) {
            \File::delete(public_path('uploads/users/'.$imagem));
            \File::delete(public_path('uploads/users/sm'.$imagem));
        }
    }


    public function ativar($id)
    {
        $user = User::findOrFail($id);
        $user->statu_id = 1;
        if ($user->save()) {
            return true;
        }
        return false;
    }

    public function ativar_cliente($id)
    {
        $user = User::where('cliente_id',$id)->first();
        $user->statu_id = 1;
        if ($user->save()) {
            return true;
        }
        return false;
    }

    public function inativar($id)
    {
        $user = User::findOrFail($id);
        $user->statu_id = 2;
        if ($user->save()) {
            return true;
        }
        return false;
    }
    public function inativar_cliente($id)
    {
        $user = User::where('cliente_id',$id)->first();
        $user->statu_id = 2;
        if ($user->save()) {
            return true;
        }
        return false;
    }

    function destroy_cliente ($id){
        $user = User::where('cliente_id',$id)->first();
        $user->delete();
    }

    public function imgUpload($file, $path){
        $width= 1300;
        $height=560;

        $file_name = Carbon::now()->timestamp . uniqid().'.'.$file->getClientOriginalExtension();
        $path = 'uploads/'.$path.'/';                  if (!file_exists($path)) {             File::makeDirectory($path, 0777, true, true);         }
        Image::make($file)->resize($width, $height)->save($path.$file_name);
        Image::make($file)->resize($width/6, $height/6)->save($path.'sm'.$file_name);

        return $file_name;
    }
}
