<?php

namespace App\Repositories;

use App\Models\Admin\Noticia;


/**
 * Class NoticiaRepository
 * @package App\Repositories\Admin
 * @version May 03, 2023, 12:37 pm UTC
 *
 * @method Noticia findWithoutFail($id, $columns = ['*'])
 * @method Noticia find($id, $columns = ['*'])
 * @method Noticia first($columns = ['*'])
 * @method Noticia all($columns = ['*'])
*/
class NoticiaRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'titulo',
        'descricao',
        'icone',
        'link',
        'statu_id',
        'banner'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Noticia::class;
    }

    public function all()
    {
         $noticia = Noticia::select('*')->get();
        return $noticia;
    }





}
