<?php

namespace App\Repositories;

use App\Models\Admin\Destaque;
use App\Models\Admin\Destaquefoto;


/**
 * Class VeiculoRepository
 * @package App\Repositories\Admin
 * @version May 03, 2023, 12:37 pm UTC
 *
 * @method Destaque findWithoutFail($id, $columns = ['*'])
 * @method Destaque find($id, $columns = ['*'])
 * @method Destaque first($columns = ['*'])
*/
class VeiculoRepository
{
    /**
     * @var array
     */
    protected $fieldSearchable = [
        'titulo',
        'foto',
        'link',
        'informacoes',
        'tipo_id',
        'statu_id',
        'destaque'
    ];

    /**
     * Configure the Model
     **/
    public function model()
    {
        return Destaque::class;
    }

    public function ver($id)
    {
        return Destaque::find($id);
    }

    public function fotos($id)
    {
         $fotos = Destaquefoto::where('destaque_id',$id)->get();
         return $fotos;
    }






}
