<?php
/**
 * Created by PhpStorm.
 * User: Daniel Risi
 * Date: 31/07/2018
 * Time: 11:20
 */

namespace App\Services;



class AuxiliarService
{
    public function __construct(){
    }

    public function converteDataToBanco($str){
        $data = explode('/',$str);
        $dataformatada = $data[2].'-'.$data[1].'-'.$data[0];
        return $dataformatada;
    }

    public function converteMoedaToBanco($valor){
        if(!empty($valor)){
            $valor = str_replace('.', '', $valor);
            $valor = str_replace(',', '.', $valor);
        }
        return (double) $valor;
    }

    public function formatWithoutRS($valor){
        if(!empty($valor)){
            $valor = str_replace('R$ ','',$valor);
            $valor = str_replace('.', '', $valor);
            $valor = str_replace(',', '.', $valor);
        }
        return (double) $valor;
    }

    public function formatRS($valor) {
        return "R$ ".number_format($valor, 2, ",", ".");
    }

    public function getPeriodo($valor){
        $periodos = [
          1 => 'Indeterminado',
          2 => '1 mês',
          3 => '6 meses',
          4 => '1 ano',

        ];
        return $periodos[$valor];
    }

    public function limpatelefone($str){
        $novotelefone = preg_replace("/[^0-9]/","",$str);
        return $novotelefone;
    }

    public static function converteDataStatic($data){
        /*
         * ENTRADA: dd/mm/aaaa
         * SAÍDA: aaaa-mm-dd
         * */

        if(!empty($data)) {
            $data = explode('/', $data);
            if (!isset($data[2])) {
                $data[2] = '0000';
            }
            $dataformatada = $data[2] . '-' . $data[1] . '-' . $data[0];
            return $dataformatada;
        }else{
            return null;
        }

    }

    public static function moedaStataic ($get_valor) {
        if(!empty($get_valor)) {
            $source = array('.', ',');
            $replace = array('', '.');
            $valor = str_replace($source, $replace, $get_valor); //remove os pontos e substitui a virgula pelo ponto
            return $valor; //retorna o valor formatado para gravar no banco
        }else{
            return null;
        }
    }

    public static function limita_caracteres($texto, $limite, $quebra = false) {
        $tamanho = strlen($texto);

        // Verifica se o tamanho do texto é menor ou igual ao limite
        if ($tamanho <= $limite) {
            $novo_texto = $texto;
            // Se o tamanho do texto for maior que o limite
        } else {
            // Verifica a opção de quebrar o texto
            if ($quebra == true) {
                $novo_texto = trim(substr($texto, 0, $limite)).'...';
                // Se não, corta $texto na última palavra antes do limite
            } else {
                // Localiza o útlimo espaço antes de $limite
                $ultimo_espaco = strrpos(substr($texto, 0, $limite), ' ');
                // Corta o $texto até a posição localizada
                $novo_texto = trim(substr($texto, 0, $ultimo_espaco)).'...';
            }
        }

        // Retorna o valor formatado
        return $novo_texto;
    }

    public static function limita_caracteres2($texto, $limite, $quebra = true) {

        $ultimo_espaco = strrpos(substr($texto, 0, $limite), ' ');

        $novo_texto = trim(substr($texto, $ultimo_espaco));

        return $novo_texto;
    }

    public static function valor_en($val)
    {
        return number_format($val, 2, ".", ",");
    }


}