<?php
/**
 * Created by PhpStorm.
 * User: Daniel
 * Date: 29/08/2018
 * Time: 11:02
 */

namespace App\Services;


use Illuminate\Support\Facades\Mail;

class MailService
{

    public function emailContato($template, $email, $configuracoes){

        $dados = array('email' => $email, 'configuracoes' => $configuracoes);


//        $view =  \View::make('mail.'.$template, compact('email', 'configuracoes'))->render();
//        echo $view;
//        die();

        Mail::send('mail.'.$template, $dados, function($message) use($configuracoes,$email)
        {
            $message->subject('[SITE] Novo contato do site')
                ->to($configuracoes['email']);
        });

        if(count(Mail::failures()) > 0) {
            return false;
        } else {
            return true;
        }
    }

    public function emailTrabalhe($template, $email, $configuracoes){

        $dados = array('email' => $email, 'configuracoes' => $configuracoes);

//        $view =  \View::make('mail.'.$template, compact('email', 'configuracoes'))->render();
//        echo $view;
//        die();

        Mail::send('mail.'.$template, $dados, function($message) use($configuracoes,$email)
        {
            if(isset($email['anexo'])){
                $message->subject('[SITE] Novo currículo do site')
                    ->to($configuracoes['email'])
                    ->attach($email['anexo']->getRealPath(), array(
                            'as'   => $email['anexo']->getClientOriginalName(),
                            'mime' => $email['anexo']->getMimeType())
                    );
            }else{
                $message->subject('[SITE] Novo currículo do site')
                    ->to($configuracoes['email']);
            }

        });

        if(count(Mail::failures()) > 0) {
            return false;
        } else {
            return true;
        }
    }


}