<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive w-100">
                <table class="table table-striped table-hover" id="banners-table">
                    <thead>
                    <tr>
                        <th>Banner</th>
                        <th class="not-mobile">Titulo</th>
                        <th class="not-mobile">Url</th>
                        <th class="not-mobile">Ordem</th>
                        <th class="not-mobile">Status</th>
                        <th class="not-mobile">Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($banners as $banner)
                        <tr>
                            <td><img src="../uploads/banners/sm{!! $banner->foto !!}" class="img-fluid"></td>
                            <td>{!! $banner->titulo !!}</td>
                            <td>{!! !empty($banner->url) ? '<a target="_blank" href="'.$banner->url.'">Link</a>' : ''  !!}</td>
                            <td>{!! $banner->ordem !!}</td>
                            <td>
                                <span class="badge {{ $banner->statu_id == 1 ? ' badge-success':' badge-warning' }}">{{$banner->status->nome}}</span>
                            </td>
                            <td>

                                {!! Form::open()!!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar banner" href="{!! route('admin.banners.edit', [$banner->id]) !!}" class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>

                                        @if( $banner->statu_id == 1 )
                                            <a title="Inativar banner" href="/admin/banners_inativa/{{base64_encode($banner->id)}}"
                                               class="btn btn-sm btn-light">
                                                <i class="fas fa-ban"></i>
                                            </a>
                                        @else
                                            <a title="Ativar banner" href="/admin/banners_ativa/{{base64_encode($banner->id)}}"
                                               class="btn btn-sm btn-light">
                                                <i class="far fa-check-circle"></i>
                                            </a>
                                        @endif
                                        <a title="Excluir banner" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este banner: '{{$banner->titulo}}'" data-href="/admin/banners_delete/{{$banner->id}}" class="btn btn-sm btn-danger">
                                            <i class="fas fa-times"></i>
                                        </a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                Nenhum banner encontrado.
                                </center>
                            </td>

                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')
    <script type="text/javascript">
        $(document).ready(function() {

            var table =  $('#banners-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[1];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                }
            });


        } );

    </script>

@endsection

