<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="blocos-table">
                    <thead>
                    <tr>
                        <th>Icone</th>
                        <th>Titulo</th>
                        <th>Subtitulo</th>
                        <th>Ordem</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($blocos as $bloco)
                        <tr>
                            <td><img src="../uploads/blocos/{!! $bloco->icone !!}" class="img-fluid"></td>
                            <td>{!! $bloco->titulo !!}</td>
                            <td>{!! $bloco->descricao !!}</td>

                            <td>{!! $bloco->ordem !!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar bloco" href="{!! route('admin.blocos.edit', [$bloco->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>


                                        <a title="Excluir bloco" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este bloco: '{{$bloco->titulo}}'" data-href="/admin/blocos_delete/{{$bloco->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                Nenhum bloco encontrado.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')

    <script type="text/javascript">


        $(document).ready(function() {

            var table =  $('#blocos-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                }
            });


        } );

    </script>

@endsection
