<script>
    $('.summernote').summernote({
        lang: 'pt-BR',
        height: 250,
        tabsize: 2,
        toolbar: [
            ['style', ['bold', 'italic', 'clear']],
            ['font', ['fontname', 'fontsize']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link']],
            ['misc', ['fullscreen', 'codeview', 'help']],

        ],
        callbacks: {
            onChange: function(contents, $editable) {
                $(this).val(contents);
            },
            onImageUpload: function(files){
                that = $(this);
                sendFile(files[0], that);
            }
        }
    });

    function elfinderDialog(context){
        var fm = $('<div/>').dialogelfinder({
            width : 840,
            height: 450,
            destroyOnClose : true,
            lang: 'pt_BR',
            customData: {
                _token: '{{ csrf_token() }}'
            },
            url: '{{ route("elfinder.connector") }}',  // connector URL
            getFileCallback : function(file, fm) {
                context.invoke('editor.insertImage', fm.convAbsUrl(file.url), function ($image) {
                    // image is not inserted yet.
                    $image.addClass('img-fluid');
                }); // <------------ after
            },
            commandsOptions : {
                getfile : {
                    oncomplete : 'close',
                    folders : false
                }
            }
        }).dialogelfinder('instance');
    }

    $('.summersimple').summernote({
        lang: 'pt-BR',
        height: 100,
        tabsize: 2,
        toolbar: [
            ['style', ['bold', 'italic', 'clear']],
            ['font', ['fontsize']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['misc', ['fullscreen', 'codeview', 'help']],
        ],
        callbacks: {
            onChange: function(contents, $editable) {
                $(this).val(contents);
            },
            onImageUpload: function(files){
                that = $(this);
                sendFile(files[0], that);
            }
        }
    });
</script>
