<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="noticias-table">
                    <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Titulo</th>
                        <th>Descrição</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($noticias as $noticia)
                        <tr>
                            <td><img src="../uploads/noticias/{!! $noticia->icone !!}" class="img-fluid"></td>
                            <td>{!! $noticia->titulo !!}</td>
                            <td>{!! $noticia->descricao !!}</td>
                            <td>
                                <span class="badge {{ $noticia->statu_id == 1 ? ' badge-success':' badge-warning' }}">{{$noticia->status->nome}}</span>

                            </td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar notícia" href="{!! route('admin.noticias.edit', [$noticia->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>
                                        @if( $noticia->statu_id == 1 )
                                        <a title="Inativar notícia" href="/admin/noticias_inativa/{{base64_encode($noticia->id)}}"
                                           class="btn btn-sm btn-light">
                                            <i class="fas fa-ban"></i>
                                        </a>
                                    @else
                                        <a title="Ativar notícia" href="/admin/noticias_ativa/{{base64_encode($noticia->id)}}"
                                           class="btn btn-sm btn-light">
                                            <i class="far fa-check-circle"></i>
                                        </a>
                                    @endif

                                        <a title="Excluir notícia" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir esta notícia: '{{$noticia->titulo}}'" data-href="/admin/noticias_delete/{{$noticia->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                Nenhuma notícia encontrado.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')

    <script type="text/javascript">


        $(document).ready(function() {

            var table =  $('#noticias-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                }
            });


        } );

    </script>

@endsection
