<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="perguntas-table">
                    <thead>
                    <tr>
                        <th>Pergunta</th>
                        <th>Resposta</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($perguntas as $pergunta)
                        <tr>
                            <td>{!! $pergunta->pergunta !!}</td>
            <td>{!! $pergunta->resposta !!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar pergunta" href="/admin/perguntas/{{$faq->id}}/{{$pergunta->id}}/edit"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>

                                        <a title="Excluir pergunta" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir está pergunta: '{{$pergunta->pergunta}}'" data-href="/admin/perguntas_delete/{{$pergunta->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3">
                                <center>
                                    <img src="/images/caixa.gif" alt="vazio">
                                Nenhum pergunta encontrada.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')




    <script type="text/javascript">

        $(document).ready(function() {

            var table =  $('#perguntas-table').DataTable( {
                 responsive: {
                                     details: {
                                         display: $.fn.dataTable.Responsive.display.modal( {
                                             header: function ( row ) {
                                                 var data = row.data();
                                                 return 'Detalhes do '+data[0];
                                             }
                                         } ),
                                         renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                                             tableClass: 'table'
                                         } )
                                     }
                                 },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
