<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="servicos-table">
                    <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Nome</th>
        <th>Subtitulo</th>

        <th>Aparecer no menu</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($servicos as $servico)
                        <tr>
                            <td><img src="/uploads/servicos/sm{!! $servico->foto !!}" class="img-fluid"></td>
                            <td>{!! $servico->nome !!}</td>
            <td>{!! $servico->subtitulo !!}</td>
            <td>{!! $servico->onmenu == 1 ? 'Sim' : 'Não' !!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Adicionar Fotos" href="/admin/servicosfotos/{{$servico->id}}"  class='btn btn-sm btn-light'><i class="fa fa-images"></i></a>
                                        <a title="Editar serviço" href="{!! route('admin.servicos.edit', [$servico->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>


                                        <a title="Excluir serviço" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este serviço: '{{$servico->nome}}'" data-href="/admin/servicos_delete/{{$servico->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5">
                                <center>
                                    <img src="/images/caixa.gif" alt="vazio">
                                Nenhum serviço encontrado.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')




    <script type="text/javascript">

        $(document).ready(function() {

            var table =  $('#servicos-table').DataTable( {
                 responsive: {
                                     details: {
                                         display: $.fn.dataTable.Responsive.display.modal( {
                                             header: function ( row ) {
                                                 var data = row.data();
                                                 return 'Detalhes do '+data[0];
                                             }
                                         } ),
                                         renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                                             tableClass: 'table'
                                         } )
                                     }
                                 },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
