<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="servicosfotos-table">
                    <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Titulo</th>
                        <th>Ordem</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($servicosfotos as $servicosfoto)
                        <tr>
                            <td><img src="/uploads/servicosfotos/sm{!! $servicosfoto->foto !!}" class="img-fluid"></td>
                            <td>{!! $servicosfoto->titulo !!}</td>
                            <td>{!! $servicosfoto->ordem !!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar foto" href="/admin/servicosfotos/{{$servico->id}}/{{$servicosfoto->id}}/edit"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>

                                        <a title="Excluir foto" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir esta foto: '{{$servicosfoto->nome}}'" data-href="/admin/servicosfotos_delete/{{$servicosfoto->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4">
                                <center>
                                    <img src="/images/caixa.gif" alt="vazio">
                                Nenhuma foto encontrada.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')




    <script type="text/javascript">

        $(document).ready(function() {

            var table =  $('#servicosfotos-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
