<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="telefones-table">
                    <thead>
                    <tr>
                        <th>Numero</th>
                        <th>Tipo</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($telefones as $telefone)
                        <tr>
                            <td>{!! $telefone->numero !!}</td>
                            <td>{!! $telefone->tipo !!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar telefone" href="{!! route('admin.telefones.edit', [$telefone->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>

                                        <a title="Excluir telefone" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este telefone: '{{$telefone->numero}}'" data-href="/admin/telefones_delete/{{$telefone->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="3">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                Nenhum telefone encontrado.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')

    <script type="text/javascript">


        $(document).ready(function() {

            var table =  $('#telefones-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
