<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="users-table">
                    <thead>
                    <tr>
                        <th class="not-mobile">Nome</th>
                        <th class="not-mobile">Email</th>
                        <th class="not-mobile">Status</th>
                        <th class="not-mobile">Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    @forelse($users as $user)
                        <tr>
                            <td>{!! $user->nome !!} </td>
                            <td>{!! $user->email !!}</td>
                            <td>{!! $user->statu_id == 1 ? '<span class="badge badge-success">Ativo</span>' : ' <span class="badge badge-warning">Inativo</span>'!!}</td>
                            <td>
                                {!! Form::open() !!}
                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        @if (Auth::user()->id == 1 || Auth::user()->id == $user->id )
                                            <a title="Editar user" href="{!! route('admin.users.edit', [$user->id]) !!}"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>

                                            @if(Auth::user()->id == 1 && Auth::user()->id != $user->id)

                                                @if( $user->statu_id == 1 )
                                                    <a title="Inativar user" href="/admin/users_inativa/{{base64_encode($user->id)}}" class="btn btn-sm btn-light"><i class="fas fa-ban"></i></a>
                                                @else
                                                    <a title="Ativar user" href="/admin/users_ativa/{{base64_encode($user->id)}}" class="btn btn-sm btn-light"><i class="far fa-check-circle"></i></a>
                                                @endif

                                                <a title="Excluir user" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este user: '{{$user->nome}}'" data-href="/admin/users_delete/{{$user->id}}" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                            @endif
                                        @endif
                                    </div>
                                </div>
                                {!! Form::close() !!}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                Nenhum user encontrado.
                                </center>
                            </td>
                        </tr>
                    @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

@section('scripts')

    <script type="text/javascript">
        $(document).ready(function() {

            var table =  $('#users-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                },
            });


        } );

    </script>

@endsection
