@extends('layouts.login')

@section('content')

    <div class="col-md-12 middle">
        <div class="card-login">
            <div class="row g-0">
                <div class="col-md-6">
                    <form class="form-horizontal form-login" role="form" method="POST" action="{{ route('login') }}">
                        @csrf
                        <div class="card-body">
                            <div class="row col-md-12 middle">
                                <div clas="form-group col-md-12">
                                    <img src="uploads/configuracoes/{{ isset($configuracoes)? $configuracoes['login'] : '' }}" class="img-fluid logo-login d-block mx-auto" alt="logo">
                                    <br><br>
                                </div>
                                <div class="row col-md-12">
                                    <div class="form-group col-md-12 @error('email') is-invalid @enderror">
                                        <br>

                                        <label for="email"><strong>{{ __('E-mail:') }}</strong></label><br>
                                        <div>
                                            <br>
                                            <input id="email" type="email" class="form-control" name="email"  placeholder="E-mail" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                        </div>
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                        <br>
                                    </div>

                                    <div class="form-group col-md-12 @error('password') is-invalid @enderror">
                                        <label for="password"><strong>{{ __('Senha:') }}</strong></label>
                                        <div>
                                            <br>
                                            <input id="password" type="password" class="form-control" name="password" placeholder="Senha" required autocomplete="current-password">
                                        </div>
                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="form-group col-md-12">
                                        <br>
                                        <input class="form-check-input" type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>

                                        <label class="form-check-label" for="remember">
                                            {{ __('Lembre de mim') }}
                                        </label>
                                        <div class="right">
                                            @if (Route::has('password.request'))

                                                <a href="{{ route('password.request') }}">
                                                    {{ __('Esqueci minha senha') }}
                                                </a>

                                                <br>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <br><br>
                                        <button type="submit" class="btn btn-login">
                                            {{ __('ACESSAR') }}
                                        </button>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>

                <div class="col-md-6">
                    <img src="images/aviso_orions.jpg" class="img-fluid imagem" alt="...">
                </div>

                </div>
            </div>
        </div>
    </div>
@endsection
