@extends('app')
@section('content')
    {{-- Banner --}}
    <div class="row mb-5 ">
        <div class="col-12 p-0 position-relative">
            <img src="/uploads/paginas/1682729071644c686ff24d8.webp" class="img-fluid w-100" alt="Banner">
            <div class="banner"></div>
        </div>
    </div>

    <div class="row mb-5">
        @if (sizeof($noticias) > 0)
            @foreach ($noticias as $noticia)
                <div class=" col-12 col-lg-12 m-5 d-flex justify-content-center">
                    <div class="col-12 col-md-5">
                        <div class="col-12 col-md-10">

                            <img src="/uploads/noticias/{{ $noticia->icone }}" class="img-fluid w-100"
                                alt="imagem {{ $noticia->titulo }}">
                        </div>

                        <div class="col-12 col-md-10 ">

                            {{ $noticia->link }}

                        </div>
                    </div>
                    <div class="col-12 col-md-5 mt-5">
                        <div class="col-12 col-md-12 ">
                            <h5 class="text-uppercase orange font27 "><strong>{{ $noticia->titulo }}</strong></h5>
                            <span class="clearfix"></span>
                        </div>

                        {{-- Descrição --}}

                        <div class="col-12 col-md-12 mt-3">
                            {!! $noticia->descricao !!}
                        </div>
                    </div>

                </div>
            @endforeach
        @endif

    </div>


    <div class="col-12 text-center mt-5">

        <h5 class=" text-uppercase orange font27"><strong>Encontre aqui as melhores opções</strong></h5>
        <div class="col-12 mt-5">
            <div class="col-12 w-100 col-md-10 ">
                <div class=' d-flex flex-wrap justify-content-center font18 px-5 gap-5'>
                    @if (sizeof($blocos) > 0)
                        @foreach ($blocos as $bloco)
                            <div class=" col-12 col-md-2 position-relative d-block effect mb-5 ">
                                {!! !empty($bloco->link)
                                    ? '<a href="' .
                                        $bloco->link .
                                        '"><img src="uploads/blocos/' .
                                        $bloco->icone .
                                        '" class="w-100" alt="' .
                                        $bloco->titulo .
                                        '"> '
                                    : '<img src="uploads/blocos/' . $bloco->icone . '" class="w-100" alt="' . $bloco->titulo . '">' !!}
                                <div
                                    class="text-uppercase legend <?= empty($bloco->descricao) ? 'd-flex justify-content-center align-items-center' : '' ?> ">
                                    <spam
                                        class="d-flex justify-content-center <?= !empty($bloco->descricao) ? 'pt-2' : '' ?>">
                                        {{ $bloco->titulo }}</spam>
                                    @if ($bloco->descricao)
                                        <spam class="d-flex justify-content-center"><small> {{ $bloco->descricao }} </small>
                                        </spam>
                                    @endif
                                </div>



                                <p class="click">Clique aqui</p>
                                </a>
                            </div>
                        @endforeach
                    @endif


                </div>
            </div>
        </div>

    @endsection
