<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::group(['middleware' => ['auth','admin']], function() {

    Route::get('/admin', 'AdminController@index');

    Route::post('admin/configuracoes', ['as'=> 'admin.configuracoes.store', 'uses' => 'Admin\ConfiguracoeController@store']);
    Route::get('admin/configuracoes/create', ['as'=> 'admin.configuracoes.create', 'uses' => 'Admin\ConfiguracoeController@create']);
    Route::put('admin/configuracoes/{configuracoes}', ['as'=> 'admin.configuracoes.update', 'uses' => 'Admin\ConfiguracoeController@update']);
    Route::patch('admin/configuracoes/{configuracoes}', ['as'=> 'admin.configuracoes.update', 'uses' => 'Admin\ConfiguracoeController@update']);
    Route::get('admin/configuracoes', ['as'=> 'admin.configuracoes.edit', 'uses' => 'Admin\ConfiguracoeController@edit']);

    Route::patch('admin/configuracoes/manutencao/{configuracoes}', ['as'=> 'admin.configuracoes.manutencao', 'uses' => 'Admin\ConfiguracoeController@manutencao']);


    Route::get('admin/integracoes', ['as'=> 'admin.integracoes.edit', 'uses' => 'Admin\IntegracoesController@edit']);
    Route::post('admin/integracoes', ['as'=> 'admin.integracoes.store', 'uses' => 'Admin\IntegracoesController@store']);
    Route::get('admin/integracoes/create', ['as'=> 'admin.integracoes.create', 'uses' => 'Admin\IntegracoesController@create']);
    Route::put('admin/integracoes/{integracoes}', ['as'=> 'admin.integracoes.update', 'uses' => 'Admin\IntegracoesController@update']);
    Route::patch('admin/integracoes/{integracoes}', ['as'=> 'admin.integracoes.update', 'uses' => 'Admin\IntegracoesController@update']);


    Route::get('admin/telefones', ['as'=> 'admin.telefones.index', 'uses' => 'Admin\TelefoneController@index']);
    Route::post('admin/telefones', ['as'=> 'admin.telefones.store', 'uses' => 'Admin\TelefoneController@store']);
    Route::get('admin/telefones/create', ['as'=> 'admin.telefones.create', 'uses' => 'Admin\TelefoneController@create']);
    Route::put('admin/telefones/{telefones}', ['as'=> 'admin.telefones.update', 'uses' => 'Admin\TelefoneController@update']);
    Route::patch('admin/telefones/{telefones}', ['as'=> 'admin.telefones.update', 'uses' => 'Admin\TelefoneController@update']);
    Route::get('admin/telefones/{telefones}/edit', ['as'=> 'admin.telefones.edit', 'uses' => 'Admin\TelefoneController@edit']);
    Route::get('admin/telefones_delete/{telefones}', ['as'=> 'admin.telefones.destroy', 'uses' => 'Admin\TelefoneController@destroy']);
    Route::get('admin/telefones_substituir/{telefones}/{tipo}', ['as'=> 'admin.telefones.replace', 'uses' => 'Admin\TelefoneController@replace']);

    Route::get('admin/users', ['as'=> 'admin.users.index', 'uses' => 'Admin\UserController@index']);
    Route::post('admin/users', ['as'=> 'admin.users.store', 'uses' => 'Admin\UserController@store']);
    Route::get('admin/users/create', ['as'=> 'admin.users.create', 'uses' => 'Admin\UserController@create']);
    Route::put('admin/users/{users}', ['as'=> 'admin.users.update', 'uses' => 'Admin\UserController@update']);
    Route::patch('admin/users/{users}', ['as'=> 'admin.users.update', 'uses' => 'Admin\UserController@update']);
    Route::get('admin/users/{users}/edit', ['as'=> 'admin.users.edit', 'uses' => 'Admin\UserController@edit']);
    Route::get('admin/users_delete/{users}', ['as'=> 'admin.users.destroy', 'uses' => 'Admin\UserController@destroy']);
    Route::get('admin/users_ativa/{users}', ['as'=> 'admin.users.ativar', 'uses' => 'Admin\UserController@ativar']);
    Route::get('admin/users_inativa/{users}', ['as'=> 'admin.users.inativar', 'uses' => 'Admin\UserController@inativar']);

    Route::get('admin/banners', ['as'=> 'admin.banners.index', 'uses' => 'Admin\BannerController@index']);
    Route::post('admin/banners', ['as'=> 'admin.banners.store', 'uses' => 'Admin\BannerController@store']);
    Route::get('admin/banners/create', ['as'=> 'admin.banners.create', 'uses' => 'Admin\BannerController@create']);
    Route::put('admin/banners/{banners}', ['as'=> 'admin.banners.update', 'uses' => 'Admin\BannerController@update']);
    Route::patch('admin/banners/{banners}', ['as'=> 'admin.banners.update', 'uses' => 'Admin\BannerController@update']);
    Route::get('admin/banners/{banners}/edit', ['as'=> 'admin.banners.edit', 'uses' => 'Admin\BannerController@edit']);
    Route::get('admin/banners_delete/{banners}', ['as'=> 'admin.banners.destroy', 'uses' => 'Admin\BannerController@destroy']);
    Route::get('admin/banners_ativa/{banners}', ['as'=> 'admin.banners.ativar', 'uses' => 'Admin\BannerController@ativar']);
    Route::get('admin/banners_inativa/{banners}', ['as'=> 'admin.banners.inativar', 'uses' => 'Admin\BannerController@inativar']);

    Route::post('admin/bannersinternos', ['as'=> 'admin.bannersinternos.store', 'uses' => 'Admin\BannersinternoController@store']);
    Route::get('admin/bannersinternos/create', ['as'=> 'admin.bannersinternos.create', 'uses' => 'Admin\BannersinternoController@create']);
    Route::put('admin/bannersinternos/{bannersinternos}', ['as'=> 'admin.bannersinternos.update', 'uses' => 'Admin\BannersinternoController@update']);
    Route::patch('admin/bannersinternos/{bannersinternos}', ['as'=> 'admin.bannersinternos.update', 'uses' => 'Admin\BannersinternoController@update']);
    Route::get('admin/bannersinternos', ['as'=> 'admin.bannersinternos.edit', 'uses' => 'Admin\BannersinternoController@edit']);

    Route::get('admin/blocos', ['as'=> 'admin.blocos.index', 'uses' => 'Admin\BlocoController@index']);
    Route::post('admin/blocos', ['as'=> 'admin.blocos.store', 'uses' => 'Admin\BlocoController@store']);
    Route::get('admin/blocos/create', ['as'=> 'admin.blocos.create', 'uses' => 'Admin\BlocoController@create']);
    Route::put('admin/blocos/{blocos}', ['as'=> 'admin.blocos.update', 'uses' => 'Admin\BlocoController@update']);
    Route::patch('admin/blocos/{blocos}', ['as'=> 'admin.blocos.update', 'uses' => 'Admin\BlocoController@update']);
    Route::get('admin/blocos/{blocos}/edit', ['as'=> 'admin.blocos.edit', 'uses' => 'Admin\BlocoController@edit']);
    Route::get('admin/blocos_delete/{blocos}', ['as'=> 'admin.blocos.destroy', 'uses' => 'Admin\BlocoController@destroy']);

    Route::get('admin/destaques', ['as'=> 'admin.destaques.index', 'uses' => 'Admin\DestaqueController@index']);
    Route::post('admin/destaques', ['as'=> 'admin.destaques.store', 'uses' => 'Admin\DestaqueController@store']);
    Route::get('admin/destaques/create', ['as'=> 'admin.destaques.create', 'uses' => 'Admin\DestaqueController@create']);
    Route::put('admin/destaques/{destaques}', ['as'=> 'admin.destaques.update', 'uses' => 'Admin\DestaqueController@update']);
    Route::patch('admin/destaques/{destaques}', ['as'=> 'admin.destaques.update', 'uses' => 'Admin\DestaqueController@update']);
    Route::get('admin/destaques/{destaques}/edit', ['as'=> 'admin.destaques.edit', 'uses' => 'Admin\DestaqueController@edit']);
    Route::get('admin/destaques_delete/{destaques}', ['as'=> 'admin.destaques.destroy', 'uses' => 'Admin\DestaqueController@destroy']);
    Route::get('admin/destaques_ativa/{destaques}', ['as'=> 'admin.destaques.ativar', 'uses' => 'Admin\DestaqueController@ativar']);
    Route::get('admin/destaques_inativa/{destaques}', ['as'=> 'admin.destaques.inativar', 'uses' => 'Admin\DestaqueController@inativar']);

    Route::get('admin/destaquesfotos/{destaque_id}', ['as'=> 'admin.destaquesfotos.index', 'uses' => 'Admin\DestaquesfotoController@index']);
    Route::post('admin/destaquesfotos', ['as'=> 'admin.destaquesfotos.store', 'uses' => 'Admin\DestaquesfotoController@store']);
    Route::get('admin/destaquesfotos/create/{destaque_id}', ['as'=> 'admin.destaquesfotos.create', 'uses' => 'Admin\DestaquesfotoController@create']);
    Route::put('admin/destaquesfotos/{destaquesfotos}', ['as'=> 'admin.destaquesfotos.update', 'uses' => 'Admin\DestaquesfotoController@update']);
    Route::patch('admin/destaquesfotos/{destaquesfotos}', ['as'=> 'admin.destaquesfotos.update', 'uses' => 'Admin\DestaquesfotoController@update']);
    Route::get('admin/destaquesfotos/{destaque_id}/{destaquesfotos}/edit', ['as'=> 'admin.destaquesfotos.edit', 'uses' => 'Admin\DestaquesfotoController@edit']);
    Route::get('admin/destaquesfotos_delete/{destaquesfotos}', ['as'=> 'admin.destaquesfotos.destroy', 'uses' => 'Admin\DestaquesfotoController@destroy']);

    Route::get('admin/noticias', ['as'=> 'admin.noticias.index', 'uses' => 'Admin\NoticiaController@index']);
    Route::post('admin/noticias', ['as'=> 'admin.noticias.store', 'uses' => 'Admin\NoticiaController@store']);
    Route::get('admin/noticias/create', ['as'=> 'admin.noticias.create', 'uses' => 'Admin\NoticiaController@create']);
    Route::put('admin/noticias/{noticias}', ['as'=> 'admin.noticias.update', 'uses' => 'Admin\NoticiaController@update']);
    Route::patch('admin/noticias/{noticias}', ['as'=> 'admin.noticias.update', 'uses' => 'Admin\NoticiaController@update']);
    Route::get('admin/noticias/{noticias}/edit', ['as'=> 'admin.noticias.edit', 'uses' => 'Admin\NoticiaController@edit']);
    Route::get('admin/noticias_delete/{noticias}', ['as'=> 'admin.noticias.destroy', 'uses' => 'Admin\NoticiaController@destroy']);
    Route::get('admin/noticias_ativa/{noticias}', ['as'=> 'admin.noticias.ativar', 'uses' => 'Admin\NoticiaController@ativar']);
    Route::get('admin/noticias_inativa/{noticias}', ['as'=> 'admin.noticias.inativar', 'uses' => 'Admin\NoticiaController@inativar']);

    Route::get('admin/servicos', ['as'=> 'admin.servicos.index', 'uses' => 'Admin\ServicoController@index']);
    Route::post('admin/servicos', ['as'=> 'admin.servicos.store', 'uses' => 'Admin\ServicoController@store']);
    Route::get('admin/servicos/create', ['as'=> 'admin.servicos.create', 'uses' => 'Admin\ServicoController@create']);
    Route::put('admin/servicos/{servicos}', ['as'=> 'admin.servicos.update', 'uses' => 'Admin\ServicoController@update']);
    Route::patch('admin/servicos/{servicos}', ['as'=> 'admin.servicos.update', 'uses' => 'Admin\ServicoController@update']);
    Route::get('admin/servicos/{servicos}/edit', ['as'=> 'admin.servicos.edit', 'uses' => 'Admin\ServicoController@edit']);
    Route::get('admin/servicos_delete/{servicos}', ['as'=> 'admin.servicos.destroy', 'uses' => 'Admin\ServicoController@destroy']);

    Route::get('admin/servicosfotos/{servico_id}', ['as'=> 'admin.servicosfotos.index', 'uses' => 'Admin\ServicosfotoController@index']);
    Route::post('admin/servicosfotos', ['as'=> 'admin.servicosfotos.store', 'uses' => 'Admin\ServicosfotoController@store']);
    Route::get('admin/servicosfotos/create/{servico_id}', ['as'=> 'admin.servicosfotos.create', 'uses' => 'Admin\ServicosfotoController@create']);
    Route::put('admin/servicosfotos/{servicosfotos}', ['as'=> 'admin.servicosfotos.update', 'uses' => 'Admin\ServicosfotoController@update']);
    Route::patch('admin/servicosfotos/{servicosfotos}', ['as'=> 'admin.servicosfotos.update', 'uses' => 'Admin\ServicosfotoController@update']);
    Route::get('admin/servicosfotos/{servico_id}/{servicosfotos}/edit', ['as'=> 'admin.servicosfotos.edit', 'uses' => 'Admin\ServicosfotoController@edit']);
    Route::get('admin/servicosfotos_delete/{servicosfotos}', ['as'=> 'admin.servicosfotos.destroy', 'uses' => 'Admin\ServicosfotoController@destroy']);

    Route::get('admin/paginas', ['as'=> 'admin.paginas.index', 'uses' => 'Admin\PaginaController@index']);
    Route::post('admin/paginas', ['as'=> 'admin.paginas.store', 'uses' => 'Admin\PaginaController@store']);
    Route::get('admin/paginas/create', ['as'=> 'admin.paginas.create', 'uses' => 'Admin\PaginaController@create']);
    Route::put('admin/paginas/{paginas}', ['as'=> 'admin.paginas.update', 'uses' => 'Admin\PaginaController@update']);
    Route::patch('admin/paginas/{paginas}', ['as'=> 'admin.paginas.update', 'uses' => 'Admin\PaginaController@update']);
    Route::get('admin/paginas/{paginas}/edit', ['as'=> 'admin.paginas.edit', 'uses' => 'Admin\PaginaController@edit']);
    Route::get('admin/paginas_delete/{paginas}', ['as'=> 'admin.paginas.destroy', 'uses' => 'Admin\PaginaController@destroy']);
    Route::get('admin/paginas_ativa/{paginas}', ['as'=> 'admin.paginas.ativar', 'uses' => 'Admin\PaginaController@ativar']);
    Route::get('admin/paginas_inativa/{paginas}', ['as'=> 'admin.paginas.inativar', 'uses' => 'Admin\PaginaController@inativar']);

    // Route::get('admin/faqs', ['as'=> 'admin.faqs.index', 'uses' => 'Admin\FaqController@index']);
    // Route::post('admin/faqs', ['as'=> 'admin.faqs.store', 'uses' => 'Admin\FaqController@store']);
    // Route::get('admin/faqs/create', ['as'=> 'admin.faqs.create', 'uses' => 'Admin\FaqController@create']);
    // Route::put('admin/faqs/{faqs}', ['as'=> 'admin.faqs.update', 'uses' => 'Admin\FaqController@update']);
    // Route::patch('admin/faqs/{faqs}', ['as'=> 'admin.faqs.update', 'uses' => 'Admin\FaqController@update']);
    // Route::get('admin/faqs/{faqs}/edit', ['as'=> 'admin.faqs.edit', 'uses' => 'Admin\FaqController@edit']);
    // Route::get('admin/faqs_delete/{faqs}', ['as'=> 'admin.faqs.destroy', 'uses' => 'Admin\FaqController@destroy']);

    // Route::get('admin/perguntas/{faq_id}', ['as'=> 'admin.perguntas.index', 'uses' => 'Admin\PerguntaController@index']);
    // Route::post('admin/perguntas', ['as'=> 'admin.perguntas.store', 'uses' => 'Admin\PerguntaController@store']);
    // Route::get('admin/perguntas/create/{faq_id}', ['as'=> 'admin.perguntas.create', 'uses' => 'Admin\PerguntaController@create']);
    // Route::put('admin/perguntas/{perguntas}', ['as'=> 'admin.perguntas.update', 'uses' => 'Admin\PerguntaController@update']);
    // Route::patch('admin/perguntas/{perguntas}', ['as'=> 'admin.perguntas.update', 'uses' => 'Admin\PerguntaController@update']);
    // Route::get('admin/perguntas/{faq_id}/{perguntas}/edit', ['as'=> 'admin.perguntas.edit', 'uses' => 'Admin\PerguntaController@edit']);
    // Route::get('admin/perguntas_delete/{perguntas}', ['as'=> 'admin.perguntas.destroy', 'uses' => 'Admin\PerguntaController@destroy']);
});



//public
Route::get('/', ['as'=> 'home', 'uses' => 'HomeController@index']);
Route::get('/noticias', ['as'=> 'noticias.ver', 'uses' => 'NoticiaController@ver']);
Route::get('/veiculos/{veiculo}', ['as'=> 'veiculos.ver', 'uses' => 'VeiculoController@ver']);

Route::get('/{slug}', ['as'=> 'paginas.ver', 'uses' => 'PaginaController@ver']);

Route::get('/servicos/{slug}', ['as'=> 'servicos.ver', 'uses' => 'ServicoController@ver']);


//orions
Route::get('/ver', 'AvisoController@index');
Route::post('/ver', 'AvisoController@store');
