<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table table-striped table-hover">
                <table class="table table-responsive" id="noticias-table">
                    <thead>
                    <tr>
                        <th>Foto</th>
                        <th>Titulo</th>
                        <th>Descrição</th>
                        <th>Status</th>
                        <th>Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $noticias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $noticia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><img src="../uploads/noticias/<?php echo $noticia->icone; ?>" class="img-fluid"></td>
                            <td><?php echo $noticia->titulo; ?></td>
                            <td><?php echo $noticia->descricao; ?></td>
                            <td>
                                <span class="badge <?php echo e($noticia->statu_id == 1 ? ' badge-success':' badge-warning'); ?>"><?php echo e($noticia->status->nome); ?></span>

                            </td>
                            <td>
                                <?php echo Form::open(); ?>

                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar notícia" href="<?php echo route('admin.noticias.edit', [$noticia->id]); ?>"  class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>
                                        <?php if( $noticia->statu_id == 1 ): ?>
                                        <a title="Inativar notícia" href="/admin/noticias_inativa/<?php echo e(base64_encode($noticia->id)); ?>"
                                           class="btn btn-sm btn-light">
                                            <i class="fas fa-ban"></i>
                                        </a>
                                    <?php else: ?>
                                        <a title="Ativar notícia" href="/admin/noticias_ativa/<?php echo e(base64_encode($noticia->id)); ?>"
                                           class="btn btn-sm btn-light">
                                            <i class="far fa-check-circle"></i>
                                        </a>
                                    <?php endif; ?>

                                        <a title="Excluir notícia" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir esta notícia: '<?php echo e($noticia->titulo); ?>'" data-href="/admin/noticias_delete/<?php echo e($noticia->id); ?>" class="btn btn-sm btn-danger"><i class="fas fa-times"></i></a>
                                    </div>
                                </div>
                                <?php echo Form::close(); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6">
                                <center>
                                    <img src="../images/caixa.gif" alt="vazio">
                                Nenhuma notícia encontrado.
                                </center>
                            </td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('scripts'); ?>

    <script type="text/javascript">


        $(document).ready(function() {

            var table =  $('#noticias-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[0];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                }
            });


        } );

    </script>

<?php $__env->stopSection(); ?>
<?php /**PATH /home/ideiapcc/lbus.ideiapc.com.br/lbus/laravel/resources/views/admin/noticias/table.blade.php ENDPATH**/ ?>