<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo e($title_for_layout); ?></title>
    <?php if(isset($keywords_for_layout)): ?>
        <meta name="keywords" content="<?php echo e($keywords_for_layout); ?>">
    <?php endif; ?>
    <?php if(isset($description_for_layout)): ?>
        <meta name="description" content="<?php echo e($description_for_layout); ?>">
    <?php endif; ?>
    <!-- css -->
    <link rel="stylesheet" href="css/bootstrap.css">

    <link rel="stylesheet" href="css/app.css">

    <?php echo $__env->yieldContent('css'); ?>

    <!-- Fonts -->

    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;600;700&display=swap"
        rel="stylesheet">

    <?php if(isset($integracoes->head)): ?>
        <?php echo $integracoes->head; ?>

    <?php endif; ?>
</head>

<body>
    <?php if(isset($integracoes->abertura)): ?>
        <?php echo $integracoes->abertura; ?>

    <?php endif; ?>
    <header>

        <div class="menu">

            <div class="nav_icons_container">
                <div class="nav_icons py-2 px-5">
                    <div class="col-12 col-md-12  row ">
                        <div class="col-12 col-md-4 d-flex gap-2 align-items-center responsive icons">
                            <?php echo isset($configuracoes->facebook)
                                ? '<a href="' . $configuracoes->facebook . '"><i class="fab fa-facebook-f fa-3x effect"></i></a>'
                                : ''; ?>

                            <?php echo isset($configuracoes->instagram)
                                ? ' <a href="' . $configuracoes->instagram . '"><i class="fab fa-instagram fa-4x effect"></i></a>'
                                : ''; ?>

                            <?php echo isset($configuracoes->linkedin)
                                ? '  <a href="' . $configuracoes->linkedin . '"><i class="fab fa-linkedin fa-4x effect"></i></a>'
                                : ''; ?>

                            <?php echo isset($configuracoes->linkedin)
                                ? '  <a href="' . $configuracoes->youtube . '"><i class="fab fa-youtube fa-4x effect"></i></a>'
                                : ''; ?>

                        </div>
                        <div
                            class="col-12 col-md-8 d-flex align-items-center justify-content-around hidden responsive text-nowrap menus">
                            <div class="col-12 col-md-2 d-flex align-items-center mail">
                                <?php if($configuracoes->email): ?>
                                    <a href="mailto:<?php echo e($configuracoes->email); ?>"
                                        class="effect gap-1 d-flex align-items-center "><i
                                            class="far fa-envelope fa-3x"></i>
                                        <h6><?php echo e($configuracoes->email); ?></h6>
                                    </a>
                                <?php endif; ?>
                            </div>

                            <div class="col-12 col-md-8 d-flex justify-content-center align-items-center time">
                                <h6>Horário de funcionamento: <?php echo e($configuracoes->funcionamento); ?></h6>
                            </div>
                            <div class="col-12 col-md-2 d-flex align-items-center ">
                                <?php if(sizeof($telefone_principal) > 0): ?>
                                    <?php $__currentLoopData = $telefone_principal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="tel:<?php echo e($key); ?>"
                                            class="effect gap-1 d-flex align-items-center "><i
                                                class="fas fa-phone fa-3x fa-rotate-90"></i>
                                            <h6> <?php echo e($tel); ?></h6>
                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <nav class="navbar navbar-expand-lg">
                <div class="container-fluid nav_px">
                    <a href="/"><img
                            src="uploads/configuracoes/<?php echo e(isset($configuracoes) ? $configuracoes['logo'] : ''); ?>"
                            alt="Logotipo <?php echo e($title_for_layout); ?>" class="img-fluid ps-3 pt-3"></a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarNavAltMarkup" aria-controls="navbarNavAltMarkup" aria-expanded="false"
                        aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse  " id="navbarNavAltMarkup">
                        <div
                            class="navbar-nav w-100 d-flex justify-content-end margin-end z-3 position-relative bg-white gap-5 ">
                            <?php $__currentLoopData = $paginas_menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(sizeof($menu->paginas) != 0): ?>
                                    <li class="nav-item dropdown">
                                        <a class="nav-link center truncate text-nowrap" href="#" role="button"
                                            data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <?php echo e($menu->nome); ?>

                                        </a>
                                        <i class="fas fa-caret-down fa-lg text-center w-100 text-danger "></i>
                                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                                            <?php $__currentLoopData = $menu->paginas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submenu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class="dropdown-item"
                                                    href="<?php echo e($submenu->slug); ?>"><?php echo e($submenu->nome); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </li>
                                <?php else: ?>
                                    <li class="nav-item">
                                        <a class="nav-link truncate text-nowrap"
                                            href="<?php echo e($menu->slug); ?>"><?php echo e($menu->nome); ?></a>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <li class="nav-link truncate text-nowrap" aria-current="page"><a
                                    href="/QuemSomos">Veículos</a></li>
                            <li class="nav-link truncate text-nowrap" aria-current="page"><a href="#">Loja
                                    Virtual</a></li>
                            <li class="nav-link truncate text-nowrap" aria-current="page"><a
                                    href="/QuemSomos">Contato</a></li>
                                    <li class="nav-item">
                                        <a class="nav-link truncate text-nowrap"
                                            href="/noticias">Notícias</a>
                                    </li>
                        </div>
                    </div>
                </div>
            </nav>


        </div>

    </header>
    <section>
        <?php echo $__env->yieldContent('content'); ?>
    </section>
    <footer class="pt-5">
        <div class="container-fluid fundo">
            <div class="row pt-5 pb-4 pad-px">
                <div class="col-12 col-md-4 my-auto d-flex justify-content-center">

                    <div class="col-12 col-md-8">
                        <h5 class="orange"><strong>ACESSO RÁPIDO</strong></h5>
                        <br>
                        <a href="/" class="effect">
                            <p> Home </p>
                        </a>
                        <hr>
                        <a href="#" class="effect">
                            <p> Quem Somos </p>
                        </a>
                        <hr>

                        <a href="#" class="effect">
                            <p> Nossos Serviços </p>
                        </a>
                        <hr>

                        <a href="#" class="effect">
                            <p> Veículos </p>
                        </a>
                        <hr>

                        <a href="#" class="effect">
                            <p> Contato </p>
                        </a>
                        <hr>
                        <br>
                    </div>

                </div>
                <div class="col-12 col-md-4 my-auto d-flex justify-content-center border-left ">

                    <div class="col-12 col-md-8 d-flex flex-wrap justify-content-center ">
                        <a href="/" class="col-12 col-md-10 pb-4"><img
                                src="uploads/configuracoes/<?php echo e(isset($configuracoes) ? $configuracoes['logorodape'] : ''); ?>"
                                alt="Logotipo <?php echo e($title_for_layout); ?>" class="img-fluid w-100"></a>

                        <div class="pb-4 row col-12 col-md-10 font18 d-flex justify-content-center ">
                            <div class="col-2 col-md-2 icon pt-3 ">
                                <i class="fas fa-phone fa-lg fa-rotate-90"></i>
                            </div>

                            <div class="col-6 col-md-9 mt-1 ">

                                <?php if(sizeof($telefone) > 0): ?>
                                    <?php $__currentLoopData = $telefone; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-12 pb-1  ">
                                            <a href="tel:<?php echo e($key); ?>" class="effect text-nowrap">
                                                <?php echo e($tel); ?>

                                            </a>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>


                            </div>

                        </div>

                        <address class="col-12 col-md-10 d-flex justify-content-center font18">
                            <div class="col-2 col-md-2 icon">
                                <i class="fas fa-map-marker-alt fa-lg pt-4"></i>

                            </div>

                            <div class="col-6 col-md-10 ">
                                <p><?php echo isset($configuracoes->rua) ? $configuracoes->rua : ''; ?>, <?php echo isset($configuracoes->numero) ? $configuracoes->numero : ''; ?><br>
                                    Bairro: <?php echo isset($configuracoes->bairro) ? $configuracoes->bairro : ''; ?> <br>
                                    CEP: <?php echo isset($configuracoes->cep) ? $configuracoes->cep : ''; ?> <br>
                                    Cidade: <?php echo isset($configuracoes->cidade) ? $configuracoes->cidade : ''; ?> | <?php echo isset($configuracoes->estado) ? $configuracoes->estado : ''; ?></p>





                            </div>

                        </address>


                    </div>
                </div>
                <div class="col-12 col-md-4 my-auto d-flex justify-content-center border-left">

                    <form class="col-12 col-md-9 ">
                        <h5 class="pb-4 ps-1 blue"><strong>Contato</strong></h5>

                        <div class=" col-12 mb-3">
                            <input type="text" class="form-control contact" placeholder="Nome">
                        </div>
                        <div class="col-12  mb-3">
                            <input type="text" class="form-control contact" placeholder="Telefone">
                        </div>
                        <div class=" col-12 mb-3">
                            <textarea class="form-control contact" placeholder="Mensagem" style="height: 150px"></textarea>

                        </div>
                        <div class=" col-12 d-flex justify-content-end">

                            <button type="submit" class="btn btn-primary button-contact">Enviar</button>
                        </div>
                    </form>
                </div>
            </div>


        </div>
        </div>
        <div class="col-12 pt-4">
            <?php echo isset($configuracoes->iframe) ? $configuracoes->iframe : ''; ?>

            <iframe class="w-100"
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3676.7366704110477!2d-45.2266617!3d-22.849230000000002!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x94ccc35f0021ef87%3A0x465662c99fa78679!2sTv.%20Luiz%20Butignon%2C%2052%2C%20Aparecida%20-%20SP%2C%2012570-000!5e0!3m2!1spt-BR!2sbr!4v1682359654687!5m2!1spt-BR!2sbr"
                width="400" height="300" style="border:0;" allowfullscreen="" loading="lazy"
                referrerpolicy="no-referrer-when-downgrade"></iframe>
            <div class="col-12 text-center copyright py-5">
                © Copyright <?php echo e(date('Y')); ?> - <?php echo isset($configuracoes->nome_aplicacao) ? $configuracoes->nome_aplicacao : ''; ?> | Desenvolvido por: Interativa Marketing
            </div>
        </div>
        </div>
    </footer>

    <!-- js -->
    <script src="js/bootstrap.js"></script>

    <script src="js/app.js"></script>

    <?php echo $__env->yieldContent('script'); ?>

    <!-- FontAwesome CSS - loading as last, so it doesn't block rendering-->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.1/css/all.css"
        integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">

</body>

</html>
<?php /**PATH /home/ideiapcc/lbus.ideiapc.com.br/lbus/laravel/resources/views/app.blade.php ENDPATH**/ ?>