<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">


    <title><?php echo e($title_for_layout); ?></title>
    <?php if(isset($keywords_for_layout)): ?>
        <meta name="keywords" content="<?php echo e($keywords_for_layout); ?>" >
    <?php endif; ?>
    <?php if(isset($description_for_layout)): ?>
        <meta name="description" content="<?php echo e($description_for_layout); ?>" >
    <?php endif; ?>

<!-- css -->
    <link rel="stylesheet" href="/css/app.css">

    <?php echo $__env->yieldContent('css'); ?>
    <link href="https://fonts.googleapis.com/css?family=Lato:400,700" rel="stylesheet">
    

    <?php if(isset($integracoes->head)): ?>
    <?php echo $integracoes->head; ?>

<?php endif; ?>
</head>

<body>
    <?php if(isset($integracoes->abertura)): ?>
    <?php echo $integracoes->abertura; ?>

<?php endif; ?>
<header>
    <div class="container-fluid">

        <div class="row py-4">
            <div class="col-12 col-md-3 offset-md-1 text-center">
                <a href="/"><img src="/uploads/configuracoes/<?php echo e(isset($configuracoes)? $configuracoes['logo'] : ''); ?>" alt="Logotipo Santa Casa de Guaratinguetá" class="img-fluid"></a>
            </div>
            <div class="col-12 col-md-7">
                <nav class="navbar navbar-expand-lg navbar-light">
                    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav mr-auto">
                            <li class="nav-item m-auto">
                                <a class="nav-link" href="/">Home</a>
                            </li>
                            <li class="nav-item dropdown">
                                <a class="nav-link " href="#" id="navbarDropdown2" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Especialidades e Serviços
                                </a>
                                <div class="dropdown-menu" aria-labelledby="navbarDropdown2">
                                    <?php $__currentLoopData = $servicos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $servico): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a class="dropdown-item" href="/servicos/<?php echo e($servico->slug); ?>"><?php echo e($servico->nome); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </li>

                        </ul>
                    </div>
                </nav>
            </div>
        </div>
    </div>
</header>
<section>
    <div class="container-fluid">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
</section>


<footer>
    <div class="container-fluid">
        <div class="row pt-5 pb-4">
            <div class="col-12 col-md-4 text-center my-auto">
                <a href=""><img src="/uploads/configuracoes/<?php echo e(isset($configuracoes)? $configuracoes['logorodape'] : ''); ?>" class="img-fluid" alt="Orions Sites e Host"></a>
            </div>

            <div class="col-12 col-md-4 text-center text-md-left pt-5 pt-md-0">
                <h5><strong>ATENDIMENTO AO CLIENTE</strong></h5>
                <p class="pb-2"><?php echo isset($configuracoes->rua) ? $configuracoes->rua : ''; ?>, <?php echo isset($configuracoes->numero) ? $configuracoes->numero : ''; ?> <br>
                    <?php echo isset($configuracoes->bairro) ? $configuracoes->bairro : ''; ?> • <?php echo isset($configuracoes->cidade) ? $configuracoes->cidade : ''; ?> • <?php echo isset($configuracoes->estado) ? $configuracoes->estado : ''; ?></p>

                <?php if(sizeof($telefone) > 0): ?>
                    <?php $__currentLoopData = $telefone; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p class="my-2"> <a href="tel:<?php echo e($key); ?>" class="d-block"><i class="fas fa-phone"></i> <?php echo e($tel); ?></a></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php if(sizeof($whatsapp) > 0): ?>
                    <?php $__currentLoopData = $whatsapp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p class="my-2">  <a href="tel:<?php echo e($key); ?>" class="d-block"><i class="fab fa-whatsapp"></i> <?php echo e($tel); ?></a> </p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>

            </div>

            <div class="col-12 col-md-4 text-center text-md-left">
                <h5><strong>SIGA-NOS</strong></h5>
                <?php echo isset($configuracoes->facebook) ? '<a href="'.$configuracoes->facebook.'" target="_blank"><i class="fab fa-facebook fa-2x"></i></a>' : ''; ?>

                <?php echo isset($configuracoes->instagram) ? '<a href="'.$configuracoes->instagram.'" target="_blank"><i class="fab fa-instagram fa-2x"></i></a>' : ''; ?>

                <?php echo isset($configuracoes->linkedin) ? '<a href="'.$configuracoes->linkedin.'" target="_blank"><i class="fab fa-linkedin fa-2x"></i></a>' : ''; ?>


            </div>
        </div>
        <div class="row">
			<div class="col-12 text-center copy pt-2 pb-4">

                <p> <?php echo $configuracoes->razaosocial; ?> © Copyright <?php echo e(date('Y')); ?> • Desenvolvido por <a href="https://www.orions.com.br" target="_blank"> Orions Sites </p>
            </div>
        </div>
    </div>
</footer>
<?php if(isset($integracoes->fechamento)): ?>
    <?php echo $integracoes->fechamento; ?>

<?php endif; ?>
<!-- js -->
<script src="/js/app.js"></script>

<?php echo $__env->yieldContent('scripts'); ?>

<!-- FontAwesome CSS - loading as last, so it doesn't block rendering-->
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.1/css/all.css" integrity="sha384-fnmOCqbTlWIlj8LyTjo7mOUStjsKC4pOpQbqyi7RrhN7udi9RwhKkMHpvLbHG9Sr" crossorigin="anonymous">
</body>
</html>
<?php /**PATH D:\xamppnew\htdocs\orions\resources\views/app.blade.php ENDPATH**/ ?>