<div class="col-lg-12 mt-3">
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover" id="banners-table">
                    <thead>
                    <tr>
                        <th>Banner</th>
                        <th class="not-mobile">Titulo</th>
                        <th class="not-mobile">Url</th>
                        <th class="not-mobile">Ordem</th>
                        <th class="not-mobile">Status</th>
                        <th class="not-mobile">Ações</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><img src="/uploads/banners/sm<?php echo $banner->foto; ?>" class="img-fluid"></td>
                            <td><?php echo $banner->titulo; ?></td>
                            <td><?php echo !empty($banner->url) ? '<a target="_blank" href="'.$banner->url.'">Link</a>' : ''; ?></td>
                            <td><?php echo $banner->ordem; ?></td>
                            <td>
                                <span class="badge <?php echo e($banner->statu_id == 1 ? ' badge-success':' badge-warning'); ?>"><?php echo e($banner->status->nome); ?></span>
                            </td>
                            <td>

                                <?php echo Form::open(); ?>

                                <div class="btn-toolbar" role="toolbar">
                                    <div class='btn-group'>
                                        <a title="Editar banner" href="<?php echo route('admin.banners.edit', [$banner->id]); ?>" class='btn btn-sm btn-light'><i class="fa fa-edit"></i></a>

                                        <?php if( $banner->statu_id == 1 ): ?>
                                            <a title="Inativar banner" href="/admin/banners_inativa/<?php echo e(base64_encode($banner->id)); ?>"
                                               class="btn btn-sm btn-light">
                                                <i class="fas fa-ban"></i>
                                            </a>
                                        <?php else: ?>
                                            <a title="Ativar banner" href="/admin/banners_ativa/<?php echo e(base64_encode($banner->id)); ?>"
                                               class="btn btn-sm btn-light">
                                                <i class="far fa-check-circle"></i>
                                            </a>
                                        <?php endif; ?>
                                        <a title="Excluir banner" href="#" data-bb="confirm" data-text="Tem certeza que deseja excluir este banner: '<?php echo e($banner->titulo); ?>'" data-href="/admin/banners_delete/<?php echo e($banner->id); ?>" class="btn btn-sm btn-danger">
                                            <i class="fas fa-times"></i>
                                        </a>
                                    </div>
                                </div>
                                <?php echo Form::close(); ?>

                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6">
                                <center>
                                    <img src="/images/caixa.gif" alt="vazio">
                                Nenhum banner encontrado.
                                </center>
                            </td>

                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function() {

            var table =  $('#banners-table').DataTable( {
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                            header: function ( row ) {
                                var data = row.data();
                                return 'Detalhes do '+data[1];
                            }
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                language: {
                    "url": "/js/pt-br.json",
                }
            });


        } );

    </script>

<?php $__env->stopSection(); ?>

<?php /**PATH D:\xamppnew\htdocs\orions\resources\views/admin/banners/table.blade.php ENDPATH**/ ?>